function MutantWildTypeError
% function MutantWildTypeError
%
% This function was written for a paper with S. Bensmihen. The user first
% selects a model, then they selected the point model file that corresponds
% to a mean mutant shape. They then selected the point model for the mean
% wild type (WT) shape. The script calculates the error between the
% observed mean shape and the observed mean WT. It then calculates the
% error between the observed mean shape and a reconstructed mean shape
% using the selected PCs from the model. 
%
% Dr. A. I. Hanna (2007)

[model] = aamio_loadModel;
if isempty(model)
    return;
end
Xm = model.Xm;
P = model.pca.P;
[P, pcind] = choosePCs(P);
if isempty(P)
    fprintf('User cancelled operation\n');
    return;
end

[mean_mutant, files] = aamio_loadPointModels('Title', 'Open Mean Mutant Point Models');
%[mean_mutant] = aamio_loadPointModel('Title', 'Open Mean Mutant Point Model');
if isempty(mean_mutant)
    return;
end
[wild_type, wtfile] = aamio_loadPointModel('Title', 'Open Mean Wild Type Point Model');
if isempty(wild_type)
    return;
end

if size(wild_type,1)~=size(mean_mutant,1)
    error('Number of points must agree');
end
% Align the point models to the mean, ignoring scale, rotation and
% translation
opts.scaling = 1;
opts.rotation = 1;
opts.translation = 1;
X = [mean_mutant, wild_type];
[X] = pcalib_GPA('data', X, 'template', Xm, 'opts', opts);

align_mut = X(:,1:end-1);
recon_mut = align_mut;
for i=1:size(align_mut,2)
    recon_mut(:,i) = Xm + P*( P'*(align_mut(:,i) -Xm) );
end
align_WT = X(:,end);
N = size(align_mut,2);
E1 = zeros(N,1);
E2 = zeros(N,1);
for i=1:N
    E1(i) = aamlib_pointModelMSE('PM1', align_mut(:,i), 'PM2', recon_mut(:,i));
    E2(i) = aamlib_pointModelMSE('PM1', align_mut(:,i), 'PM2', align_WT);
    [junk, filename] = fileparts(files{i});
    fprintf('\n\nFilename: %s\n', filename);
    fprintf('MSE between observed mean and reconstructed mean for , E1 = %3.3f\n', E1(i));
    fprintf('MSE between observed mean and observed WT, E2 = %3.3f\n', E2(i));
    fprintf('Ratio E1/E2 = %3.3f\n', E1(i)/E2(i));
end

excel = questdlg('Would you like to save the result to Excel?', ...
                         'Save?', 'Yes', 'No', 'Yes');
if isempty(excel)
    return;
end
if strcmpi(excel, 'yes')
    [filename, pathname] = uiputfile('*.xls', 'Save as...');
    if isequal(filename,0) || isequal(pathname,0)
        disp('User pressed cancel');
        return
    end
 sheet = createExcelFormat(E1, E2, files, wtfile);
    xlswrite(fullfile(pathname, filename), sheet);
end


% figure; 
% hold on;
% plot(Xm(1:2:end), Xm(2:2:end), '-o', 'Color', 'r');
% plot(align_mut(1:2:end), align_mut(2:2:end), '-x', 'Color', 'b');
% plot(recon_mut(1:2:end), recon_mut(2:2:end), ':s','Color', 'k');
% plot(align_WT(1:2:end), align_WT(2:2:end), '-d','Color', 'g');
% legend('Mean Shape From Model', 'Mean Mutant Shape',  'Reconstructed Mean Mutant', 'Mean Wild Type Shape');
% axis image;

%fprintf('MSE between observed mean and reconstructed mean, E1 = %3.3f\n', E1);
%fprintf('MSE between observed mean and observed WT, E2 = %3.3f\n', E2);
%fprintf('Ratio E1/E2 = %3.3f\n', E1/E2);


%%%
%
%%%
function [P, s] = choosePCs(P)
N = size(P,2);
str = cell(N,1);
for i=1:N
    str{i} = num2str(i);
end
[s,v] = listdlg('Name', 'PC Selection', 'PromptString','Select PCs to use in reconstruction:',...
    'SelectionMode','multiple',...
    'ListString',str, 'ListSize', [600, 300]);
P = P(:,s);
return


%%%
%
%%%
function sheet = createExcelFormat(E1, E2, files, wtfile)
sheet = {};
num_files = length(files);
sheet{1,1} = 'Wild Type Filename:';
[junk, filename] = fileparts(wtfile);
sheet{1,2} = filename;

sheet{3,1} = 'Filename';
sheet{3,2} = 'E1';
sheet{3,3} = 'E2';
sheet{3,4} = 'E1/E2';
for i=1:num_files
    [junk, filename] = fileparts(files{i});
    sheet{i+3,1} = filename;
    sheet{i+3,2} = E1(i);
    sheet{i+3,3} = E2(i);
    sheet{i+3,4} = E1(i)/E2(i);

end
return