function pmsheets = constructPCInfoSheet(model)

pmsheets = {};
pdm = get(model, 'pdm');
if isempty(pdm)
    return;
end
P = pdm.pca.P;
[N, M] = size(P);
if N~=M
    fprintf('P matrix is not square and therefore not full rank, aborting the export\n');
    return;
end

template = get(model, 'PointModelTemplate');
templatename = get(template, 'name');
temppts = get(template, 'pts');
temppts = temppts(:);
numsheets = ceil(length(temppts)/250);
pmsheets = {};
for i=1:numsheets
    pmsheets{i} = {};
end

waitbar_h = waitbar(0, 'Exporting PC vectors...');
sheet_num = 1;
indx = 1;
for ii=1:M
    waitbar(ii/M, waitbar_h);
    if mod(ii,250)==0
        pmsheets{sheet_num} = sheet;
        sheet_num = sheet_num+1;
        sheet = pmsheets{sheet_num};
        indx = 1;
    end
    p = P(:,ii);
    for i=1:length(p)
        sheet{i, indx} = p(i);
    end
    indx = indx + 1;
end
pmsheets{sheet_num} = sheet;
close(waitbar_h);
return;