function varargout = plot_shape(varargin)
% Dr. A. I. Hanna (2005) CMP, UEA, 2006.
error(nargchk(0,inf,nargin));
pts = [];
c = [0 0 1];
axis_h = gca;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error('Arguments to plot_shape must come param/value in pairs.')
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            pts = varargin{i+1};
        case 'color'
            c = varargin{i+1};
        case 'axis_handle'
            axis_h = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to plot_shape.  Name was ' varargin{i}])
    end
end
if isempty(pts)
    error('PTS parameter is required.')
end
switch size(pts,2)
    case 2
        ph = plot(pts(:,1), pts(:,2), 'o', 'MarkerFaceColor', c);
    case 3
        ph = plot3(pts(:,1), pts(:,2), pts(:,3), 'o', 'MarkerFaceColor', c);
    otherwise
        fprintf('Make sure the columns of pts are the dimensions, Nx2 or Nx3\n');
end