function ShowDetails(arg)
% if strcmp(arg, 'init')
fig = openfig(mfilename, 'reuse');
Data.handles = guihandles(fig);
Data.handles.figMain = fig;
DataMain = guidata(findobj('Tag', 'AAMToolbox'));
%DataMain.handles.AAM
Data.handles = FillFields(Data.handles, DataMain.handles);
guidata(fig, Data);


function [handles] = FillFields(h, handles)
aam = struct(handles.AAM);
set(h.imdir, 'String', cut_string(aam.imageDirectory));
if isempty(aam.imageFilenames)
    set(h.imf, 'String', 'No images in the ''Cropped'' directory');

else
    
set(h.imf, 'String', aam.imageFilenames);
end
set(h.name, 'String', cut_string(aam.modelName));
set(h.direc, 'String', cut_string(aam.modelDirec));
set(h.pdmdirec, 'String', cut_string(aam.pdmDirec));
set(h.pdmname, 'String', cut_string(aam.pdmName));
set(h.sfamdirec, 'String', cut_string(aam.sfamDirec));
set(h.sfamname, 'String', cut_string(aam.sfamName));
set(h.rootDir, 'String', cut_string(aam.rootDir));
set(h.ae, 'String', num2str(aam.activeElements));
set(h.pmt, 'String', get(aam.PointModelTemplate, 'name'));
set(h.ce, 'String', num2str(aam.completeElements));
return;
%%%%%%%%%%%%%%%%%%%%%%
%
%  cut_string   //splits directory names so you can see the beginning and
%                   //the end
%%%%%%%%%%%%%%%%%%%%%%
function [s] = cut_string(s)
if (length(s)>83)
    s = [s(1:40), '...', s(end-40:end)];
end