function show_app_ellipsoid_walk(varargin)
% show_app_ellipsoid_walk('model_dir', 'StatisticalModels\1239_III\Set_1\ImageList_2\', 'stepsize', 0.2);
%
%
% Default params
% movie_dir = '';
% appPC = [1 2 3];
% stepsize = .1;
% pdm = [];
% sfam = [];
% model_dir = '';
% 
% Dr. A. I. Hanna (2007)

% Default params
movie_dir = '';
appPC = [1 2 3];
stepsize = .1;
pdm = [];
sfam = [];
model_dir = '';

%%%%%%%%%%%%%%%%%%%%%%%
%
% Setup the parameters
%
%%%%%%%%%%%%%%%%%%%%%%%
figurecol = [0 0 0];
xaxiscol = 'm';
yaxiscol = 'c';
zaxiscol = 'y';
ptedgecol = 'r';
ptfacecol = 'y';
ellipcol = [132 132 255]/255;
% Sizes
axiswidth = 2;
ptsize = 10;
std_lim = 2;
% Flags
show_pts = 0;
show_sfam = 0;


for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'movie_dir'
            movie_dir = varargin{i+1};
        case 'shapepc',
            appPC = varargin{i+1};
        case 'std_lim'
            std_lim = varargin{i+1};
        case 'stepsize'
            stepsize = varargin{i+1};
        case 'model_dir'
            model_dir = varargin{i+1};
        case 'show_sfam'
            show_sfam = varargin{i+1};
        case 'show_pts'
            show_pts = varargin{i+1};
        case 'figurecol'
            figurecol = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(model_dir)
    error('Parameter model_dir required');
end
pdm_file = [model_dir, filesep, 'mod_pdm.mat'];
sfam_file = [model_dir, filesep, 'mod_sfam.mat'];

% make sure there is a directory to write to if we want to
if ~isempty(movie_dir) && ~exist(movie_dir, 'dir')
    mkdir(movie_dir);
end
if ~exist(pdm_file, 'file')
    uiwait(msgbox('Could not find a shape model, exiting.','No model','modal'));
    return;
end

pdm = load(pdm_file);
pdm = pdm.pdm;
if ~exist(sfam_file, 'file')
    uiwait(msgbox('Could not find an appearance model, exiting.','No model','modal'));
    return;
end
sfam = load(sfam_file);
sfam = sfam.sfam;


%%%%%%%%%%%%%%%%%%%%%%%
%
% Open the figure for use
%
%%%%%%%%%%%%%%%%%%%%%%%
fig_handle = openfig('show_model.fig');
movegui(fig_handle, 'center');
handles = guihandles(fig_handle);
image_axis = handles.image_axis;
cloud_axis = handles.cloud_axis;
set(fig_handle, 'Color', figurecol);
set(fig_handle, 'Visible', 'on');
set(fig_handle, 'InvertHardcopy', 'off');
%%%%%%%%%%%%%%%%%%%%%%%
%
% Setup model information
%
%%%%%%%%%%%%%%%%%%%%%%%

Xm = pdm.Xm;
shape_model = Xm;
variation = sfam.pca.b(appPC);
sz = sfam.siz;
Am = sfam.Am;
Pa = sfam.P(:, appPC);
ba = sfam.b;
ompts = sfam.ompts;
A = Am;
I = reshape(A, [sz(2) sz(1) sz(3)]);


showVarianceEllipseWithAxes('variances', variation, 'parent', cloud_axis, 'std_lim', std_lim);
ph = plot3(cloud_axis, 0,0,0,'o', 'MarkerSize', ptsize, 'MarkerEdgeColor', ptedgecol, 'MarkerFaceColor', ptfacecol);

%%%%%%%%%%%%%%%%%%%%%%%
%
% Draw the shape and appearance model
%
%%%%%%%%%%%%%%%%%%%%%%%
shape_model = reshape(shape_model, 2, length(shape_model)/2)';
shape_model = shape_model- ones(size(shape_model,1),1)*min(shape_model,[],1) + 100;
shp_range = max(shape_model,[],1);
shp_mu = mean(shape_model,1);

currentImage = uint8(triwarp(I,ompts,shape_model));
image_h = imagesc(uint8(currentImage), 'Parent', image_axis);
hold(image_axis, 'on');
pts_h = plot(image_axis, shape_model(:,1), shape_model(:,2), 'o', 'MarkerEdgeColor', ptedgecol, 'MarkerFaceColor', ptfacecol);
if show_pts == 0
    set(pts_h, 'Visible', 'off');
end
xlim = get(image_axis, 'XLim');
ylim = get(image_axis, 'YLim');
buff = 100;
axis(image_axis, 'ij', 'image');
axis(image_axis, [1 xlim(2)+buff 1 ylim(2)+buff]);

drawnow;
set(cloud_axis, 'Visible', 'off');
set(image_axis, 'Visible', 'off');

axis(cloud_axis, 'vis3d');

%%%%%%%%%%%%%%%%%%%%%%%
%
% Walk Through The Model
%
%%%%%%%%%%%%%%%%%%%%%%%
std_vals = sqrt(variation);
pause(1);
indx = 1;
sz = sfam.siz;
for j=1:3
    pcvals = [0:stepsize:std_lim, std_lim:-stepsize:-std_lim, -std_lim:stepsize:0];
    model_b = zeros(3,1);
    for i=pcvals
        model_b(j) = i;
        set(ph, 'XData', std_vals(1)*model_b(1), 'YData', std_vals(2)*model_b(2),'ZData', std_vals(3)*model_b(3));
        shape_params = sqrt(variation).*model_b;
        app_model = Am + Pa*shape_params;
        app_model = uint8(reshape(app_model, [sz(2) sz(1) sz(3)]));
        
        app_model = uint8(triwarp(app_model,ompts,shape_model));
        set(image_h, 'CData', app_model);
        drawnow;
        if ~isempty(movie_dir)
            movieimname = [movie_dir, filesep, 'img_', num2str(indx, '%0.3d'), '.jpg'];
            print(fig_handle, '-djpeg100', movieimname);
        end
        indx = indx + 1;
        i
    end
    
end
