function VOL=MSRshowVOL(VOL,MSR)
    % function VOL=MSRshowVOL(VOL,MSR)
    %
    % use VolViewer to plot (or delete) 3D data from an MSR (shape outline) results file
    % it saves the MSR data to a temporary file 'Temp.msr' in 
    % fullfile(VOL.PathToWatchFile,'TempVolViewerData')
    %
    % VOL, VolViewer object
    % MSR, the shape information (default - select an .msr file
    %      if MSR == 1 (i.e. a scalar) then any existing MSR plot is deleted
    % AxesH, handle to the axis in which it will be plotted
    %
    % J. Andrew Bangham, 2012
    if nargin<2
        [FileName,PathName,FilterIndex]=uigetfile('*.msr','Select an msr (results) file');
        if ischar(FileName)
            pathfilename=fullfile(PathName,FileName);
            MSR=msrfilereader(pathfilename);
        else
            return
        end
    end
    % save the MSR file in the VolViewerTempMSR directory
    PathName=fullfile(VOL.PathToWatchFile,'TempVolViewerData');
    if exist(PathName)~=7
        mkdir(PathName);
    end
    msrfilewriter(fullfile(PathName,'Temp.msr'),MSR);
    VOL=showImageOrMSRusingVOL(VOL, 'PathTo', PathName,'msrFilename','Temp.msr');
end