function [VOL,SoftError]=commandsVOL(VOL,varargin)
    % [VOL,SoftError]=commandsVOL(VOL,varargin)
    %
    % Sends commands to VolViewer by writing them into the WatchFile
    %
    % Usage
    % VOL=commandsVOL(VOL,'set_channels(0, 0, 0)');
    %
    % J.Andrew Bangham 2012
    if nargin<2
        error('needs VolViewer object and at least one command');
    end
    commands={};
    for i=1:numel(varargin)
        arg=varargin{i};
        % simple check on commands
        prefix=upper(arg(1:3));
        ind=regexp(arg,'_');
        midfix=upper(arg(ind+1:ind+3));
        switch prefix
            case 'OPE'
                ind1=regexp(arg,'''');
                ind2=regexp(arg,'[()]');
                ind3=regexp(arg,',');
                if length(ind1)~=2 || length(ind2)~=2 || length(ind3)<1
                    error('VolViewer command syntax');
                end
                switch midfix
                    case 'IMA'
                    case {'MSR','SLC','TFN','VVR','OBJ'}
                    case 'OME'
                    otherwise
                        error('VolViewer command syntax');
                end
            case 'SAV'
                ind1=regexp(arg,'''');
                ind2=regexp(arg,'[()]');
                ind3=regexp(arg,',');
%                 if length(ind1)~=2 || length(ind2)~=2 || ~isempty(ind3)
%                     error('VolViewer command syntax');
%                 end
                switch midfix
                    case 'IMA'
                    case {'MSR','SLC','TFN','VVR','OBJ'}
                    case 'OME'
                    case 'TEX'
                    otherwise
                        error('VolViewer command syntax');
                end
            case 'SET'
            case 'MOV'
            case 'COM'
            case 'WAI'
            otherwise
                fprintf(1,'%s is unrecognised command: %s\n',prefix,arg);
                error('Error calling commandsVOL');
        end
        commands{i}=arg;
    end
    pathWatchFileName=fullfile(VOL.PathToWatchFile,sprintf('WatchFile%1d.txt',VOL.WatchFileNumber));
    pathLogFileName  =fullfile(VOL.PathToWatchFile,sprintf('LogFile%1d.txt',  VOL.WatchFileNumber));
    %if exist(pathLogFileName)==2
        fid=fopen(pathWatchFileName,'w');
        if fid~=-1
            for i=1:numel(commands)
                fprintf(fid,'%s\n',commands{i});
                fprintf(1,'\nVolViewer command: %s\n',commands{i});
            end
            fclose(fid);
        else
            error(sprintf('Failed to write WatchFile with %s',string))
        end
%     else
%         SoftError='VolViewer not responding';
%     end
end