function output=get(VO,varargin)
    %function output=get(VO,varargin)
    %Gets contents of specified field(s)
    %VO, VolViewer object
    %
    %output=get(VO); %returns a structure with all fields represented
    output={};
    fields=fieldnames(VO);
    k=0;
    if isempty(varargin) % return a structure with all fields represented
        output=struct(VO);
    else
        for i=1:1:numel(varargin)
            k=k+1;
            arg=varargin{i};
            recognised(k)=false;
            for j=1:numel(fields)
                field=fields{j};
                if strcmpi(field,arg)
                    recognised(k)=true;
                    if iscell(VO.(field))
                        output(end+1)=VO.(field);
                    else
                        output{end+1}=VO.(field);
                    end
                    %fprintf(1,'Recognised %s and set answer to ',field);
                    %output{end}
                    break
                end
            end
            if recognised(k)==false
                error(sprintf('Unrecognised argument: %s',arg));
            end
        end
    end
end