function printtree(s, level)
% function printtree(s)
%
% A simple method that shows the general structure of your tree
%
% Dr. A. I. Hanna (2006)
if nargin==1
    level = 0;
end
f = fields(s);
str = '';
for i=1:level; str = [str, sprintf('\t')]; end;
fprintf('%sLevel %d\n', str, level);
for i=1:length(f)
    fprintf('%s\t - %s\n', str, f{i});
end
children = getchildren(s);

for i=1:length(children)
    if istree(children{i})
        printtree(children{i}, level+1);
    end
end

return;