function MSR=MSRread2Matlab(PathName,FileName)
    % MSR=MSRread2Matlab(PathName,FileName)
    %
    % uses msrfilereader to read MSR file and then converts
    % vertex indexing to start from 1 instead of 0
    %
    % Also see
    % MSRwriteFromMatlab(MSR,PathName,FileName);
    %
    % J. Andrew Bangham, 2012
    pathfilename=fullfile(PathName,FileName);
    MSR=msrfilereader(pathfilename);
    % change numbering convention to start from 1 instead of 0 (which is part of the MSR standard)
    for i_object=1:numel(MSR.OBJECT)
        obj=MSR.OBJECT{i_object};
        if isfield(obj,'EDGE')
            if ~isempty(obj.EDGE)
                obj.EDGE=obj.EDGE+1;
            end
        end
        if isfield(obj,'FACE')
            if ~isempty(obj.FACE)
                obj.FACE=obj.FACE+1;
            end
        end
        MSR.OBJECT{i_object}=obj;
    end
end