function MakeVideosAndFLV( max_width, pngs, input_video_folder,input_video_name,finalPicFileName)
    %function MakeVideosAndFLV( max_width, pngs, input_video_folder,input_video_name,finalPicFileName)
    %
    % based on ---=== VIDEO2FLV ===---
    %
    % AUTHORS
    % 	Vincent Garcia and Sylvain Boltz
    %
    % 	1. Convert a video (MPEG, WMV, AVI) into a Adobe Flash Video (FLV). The
    % 	   conversion process is performed using the FFMPEG application.
    %
    % max_width, default 0 same as input file, else say 250 for small files
    % pngs, default 0 none, else 1 for just first and 2 for first and last
    %              frames as pngs
    % output_video_folder,output_video_name,
    % output_pngs, default 0, value 1 and it outputs first frame, 2 and it
    %              outputs both the first and last frames
    %
    % Usage
    % MakeVideosAndFLV( 400, 0, moviefilepath  ,[moviefilename,'.avi'],finalPicFileName );
    % J. Andrew Bangham, 2011
    

    % does ffmpeg.exe exist and if so where is it?
    % first check record in the Growth toolbox root directory
    [pathstr, name, ext]=fileparts(which('GFtbox'));
    if exist(fullfile(pathstr,'Path2ffmpeg.txt'))==2
        Path2ffmpeg=char(load(fullfile(pathstr,'Path2ffmpeg.txt'),'-ascii'));
%         fid=fopen(fullfile(pathstr,'Path2ffmpeg.txt'),'r');
%         Path2ffmpeg=fgetl(fid);
%         fclose(fid);
    else
        Path2ffmpeg='';
    end
    % check that ffmpeg is there
    [a,b]=system(fullfile(Path2ffmpeg,'ffmpeg.exe'));
    if isempty(regexpi(b,'ffmpeg version'))
        [filename,Path2ffmpeg]=uigetfile('.exe','Locate your copy of ffmpeg.exe','ffmpeg.exe');
        if filename==0
            disp('ffmpeg.exe not found. Please obtain from http://www.ffmpeg.org/');
            disp('put a 64 bit copy into C:Program Files')
            disp('In windows 7 right click on Computer off the start menu');
            disp('Click on properties')
            disp('Advanced system settings')
            disp('Environement Variables')
            disp('Ensure that c:\Program files is on the path');
            return; 
        else % write path into Growth toolbox root directory
            save(fullfile(pathstr,'Path2ffmpeg.txt'),'Path2ffmpeg','-ascii');
        end
    end

    if nargin<1
        max_width=0; % pixels
    end
    if nargin<2
        pngs=0; 
    end
    if nargin<3
        input_video_folder = 'D:\ab\Matlab stuff\GPT_icon_20110524\movies\';%'C:\myFolder\';
    end
    if nargin<4
        input_video_name   = 'GPT_icon_20110524-0001.avi'; %'myVideo.avi';
    end
    rootname=input_video_name(1:end-4);
    v_in   = fullfile(input_video_folder, input_video_name);
    v_out  = fullfile(input_video_folder,    [rootname,'.flv']);
    i_out_first=fullfile(input_video_folder, [rootname, '_First.png']);
    i_out_last=fullfile(input_video_folder,  [rootname, '_Last.png']);
    mm=mmfileinfo(v_in);
    % ENCODING VIDEO
    v_b    = 1000;       % video bitrate  e.g. >=1000 (less is not possible)
    v_fr   = 10;        % frame rate e.g. [25]
    v_qmin = 2;%1;         % minimum video quantizer scale e.g. [2]
    v_qmax = 5; %10;        % maximum video quantizer scale e.g. [5] larger produces smaller file but blurred movement
    width= mm.Video.Width;
    height= mm.Video.Height;
    if max_width==0
        v_w=width;
        v_h=height;
    else
        v_w=max_width;
        v_h=floor(height*v_w/width);
    end
    % encode
    v_size = sprintf('%dx%d',v_w,v_h);
    encode_video = sprintf('"%s" -i "%s" -vcodec flv -s %s -b %d -r %d -qmin %d -qmax %d "%s"',...
        fullfile(Path2ffmpeg,'ffmpeg.exe'),v_in,v_size,v_b,v_fr,v_qmin,v_qmax,v_out);
    disp('Convert movie to flash format, .flv');
    [status, result] = system(encode_video);
    disp('Done conversion of movie to flash format, .flv');
    if status==0
        disp('Conversion done');
    else
        disp(sprintf('Conversion failed: %s',result));
    end
    if ~isempty(which('VideoReader')) %true %pngs>0
%         make_jpegs=sprintf('"%s" -i %s -r 1 -s %dx%-d -f image2 %s-%%03d.jpeg',...
%             fullfile(Path2ffmpeg,'ffmpeg.exe'),v_out,v_w,v_h,fullfile(input_video_folder,rootname));
%         system(make_jpegs);
        
        xyloObj = VideoReader(v_in);
        
        nFrames = xyloObj.NumberOfFrames;
        vidHeight = xyloObj.Height;
        vidWidth = xyloObj.Width;
        
        % Preallocate movie structure.
        mov(1:nFrames) = struct('cdata', zeros(vidHeight, vidWidth, 3, 'uint8'),'colormap', []);
        %if pngs==1
            cdata = read(xyloObj, 1);
            im=imresize(cdata,[v_w,v_h]);
            imwrite(im,i_out_first);
%             imlast_filename = fullfile(input_video_folder, [input_video_name(1:end-4),'.png']);
%             imlast=imread(finalPicFileName);
%             im=imresize(cdata,[v_w,v_h]);
%             imwrite(im,i_out_last);
% %         else
% %             for k = 1 : nFrames
% %                 mov(k).cdata = read(xyloObj, k);
% %             end
% %             im=imresize(mov(1).cdata,[v_w,v_h]);
% %             imwrite(im,i_out_first);
% %             im=imresize(mov(end).cdata,[v_w,v_h]);
% %             imwrite(im,i_out_last);
% %         end
    end
end