function varargout = loadVolumeFromSlicesDir(varargin)
% function varargout = loadVolumeFromSlicesDir(varargin)
% 
% Description:
% Function to load slices given the directory where the slices reside. The
% matlab supported image formats are tried in turn to load a volume
% comprising image slices in the given directory. As soon as one or more
% image files of a given type are encounterd, all the images with the given
% extension are assumed to comprise the volume and image search stops.
% 
% Author: Johann Strasser
% Date: 070326

volume = [];
message = 'Reading volume from disk...';

if length(varargin)>1
    for i = 1:2:length(varargin)
        switch(lower(varargin{i}))
            case 'fullvolumepath'
                fullVolumePath = varargin{i+1};
            case 'message'
                message = varargin{i + 1};
            otherwise
                error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}]);
        end
    end
end

imf = imformats;
formatCounter = 1;

% Scan through the matlab supported image formats and check if directory
% contains images, if yes load slices
while isempty(volume) && formatCounter <= length(imf)
    
    extensionCounter = 1;
    
    while isempty(volume) && extensionCounter <= length(imf(formatCounter).ext)
        
        volume = loadVolumeFromSlicesDirTyped('fullVolumePath', fullVolumePath, ...
            'extension', char(imf(formatCounter).ext{extensionCounter}), 'message', message);
        extensionCounter = extensionCounter + 1;
    end
    
    formatCounter = formatCounter + 1;
end

varargout{1} = volume;