function varargout = mctlib_normalise(varargin)
% function varargout = mctlib_normalise(varargin)
%
% Normalises a data set so it has zero mean and unit scale.
%
% Inputs:
% 'pts' - the points to normalise
%
% See also: mctlib_CalcParam, mctlibCalcVel, mctlib_GaussGram
%
% Dr. A. I. Hanna (2007)
error(nargchk(0,inf,nargin));
x = [];
datax = [];
calcdataxflag = 0;
if mod(length(varargin),2) ~= 0
    % input args have not com in pairs, woe is me
    error(['Arguments to ', mfilename, ' must come param/value in pairs.'])
end
for i=1:2:length(varargin)
    switch lower(varargin{i})
        case 'pts'
            x = varargin{i+1};
        case 'datax'
            datax = varargin{i+1};
        otherwise
            error(['Unknown parameter name passed to ', mfilename, '.  Name was ' varargin{i}])
    end
end
if isempty(x)
    error('Parameter X must be supplied');
end
if isempty(datax)
    calcdataxflag = 1;
end
if calcdataxflag
    datax.mu = mean(x);
end
n = size(x,1);
x = x - ones(n,1)*datax.mu;
if calcdataxflag
    datax.scale=sqrt(sum(sum(x.^2,2))/n);
end
x = x./datax.scale;
varargout{1} = x;
varargout{2} = datax;
return