function [x, R] = pcalib_rotateshape(x, template)
% function [x, R] = pcalib_rotateshape(x, template)
%
% Takes a general shape x and a template shape t. The function returns a shape y and 
% a matrix R such that arg min ||y - template|| 
%
% Dr. A. I. Hanna (2007)
A = x*template';
[U, S, V] = svd(A);
R = V*U';
x = R*x;
return