function R=range(X,mask);
%R=range(X,mask);
%       Find range of values in X contained within mask.
%       R   : [min_value max_value];
%
%       (c) Stephen Impey, 1996
%
if nargin<1,
    error('Insufficient arguments');
end
if nargin>=2,
    if any(size(X)~=size(mask)),
        error('X and mask should be same size');
    end
    X=X(find(mask>0));
else
    X=X(:);
end
R=[min(X) max(X)];