function [output] = templateBuilder3DToolVolViewer(AAMShapemodel_figure_handle)
    % templateBuilder3DToolVolViewer M-file for templateBuilder3DTool.fig
    %
    % Description:
    %
    %
    % Author: Andrew Bangham
    % Date: 2012
    % get the data structure from the main work flow control window
    Data = guidata(AAMShapemodel_figure_handle);
    % ensure that the MSR structure is consistent with the AAM structure
    if isfield(Data,'TemplateMSR')
        ThereIsTemplateMSR=true;
    else
        ThereIsTemplateMSR=false;
    end
    pmt=get(Data.handles.AAM,'PointModelTemplate');
    if ~isempty(pmt)
        pts=get(pmt,'pts');
        if ~isempty(pts)
            ThereIsTemplateAAM=true;
        else
            ThereIsTemplateAAM=false;
        end
    else
        ThereIsTemplateAAM=false;
    end
    if ThereIsTemplateAAM && ~ThereIsTemplateMSR % create MSR from AAM
        %pathfilename=fullfile('D:\ab\Matlab stuff\Shape_models\MSR\1554_T0','1554_T0_growth.msr');
        %tempMSR=msrfilereader(pathfilename);
        %MSRObject=tempMSR.OBJECT{1};
        pmt=get(Data.handles.AAM,'PointModelTemplate');
        
        
%         pts=get(pmt,'pts');
%         primaries=get(pmt,'primaries');
%         loops=get(pmt,'loops');
% %         if numel(loops>1)
% %             fprintf(1,'WARNING: more than one ''loop'' use first loop only\n');
% %         end
%         loops=loops{1};
%         
%         MSRObject.OBJECT='FromAAM';
%         MSRObject.RENDERTYPE='MESH';
%         MSRObject.VERTCOUNT=size(pts,2);%40
%         MSRObject.VERT=pts'; %[40x3 double]
%         MSRObject.VERTLABEL=repmat({'Secondary'},size(pts,2),1);% {40x1 cell}
%         for i=1:length(primaries)
%             MSRObject.VERTLABEL(primaries(i))={'Primary'};
%         end
%         if ~isempty(loops)
%             MSRObject.EDGECOUNT=size(loops,1);%: 98
%             MSRObject.EDGE=loops; %[98x2 int32]
%             MSRObject.EDGELABEL=repmat({''},size(loops,1),1);%: {98x1 cell}
%         end
%         if isfield(Data.handles,'Facets')
%             MSRObject.FACECOUNT=size(Data.handles.Facets.facs,1); %: 59
%             MSRObject.FACE=Data.handles.Facets.facs; % [59x3 double]
%             for i=1:length(Data.handles.Facets.labels)
%                 a(1)=Data.handles.Facets.labels{i,1};
%                 a(2)=Data.handles.Facets.labels{i,2};
%                 a(3)=Data.handles.Facets.labels{i,3};
%                 MSRObject.FACELABEL{i}=a; %: {59x1 cell};
%             end
%         end
%         
       
        
%         Data.TemplateMSR.MSR_VERSION= '1.2';
%         imageDirectory=get(Data.handles.AAM,'imageDirectory');
%         Data.TemplateMSR.ORIGINALDATA={'PATH',fullfile(pwd,imageDirectory)};
%         Data.TemplateMSR.SCALE=[1 1 1];% [24.6776 24.6776 24.6776]
%         Data.TemplateMSR.TIME=0;
%         Data.TemplateMSR.ALGORITHM='VolViewer rev218';
%         Data.TemplateMSR.OBJECT{1}=MSRObject;%{[1x1 struct]}
       
        Data.TemplateMSR = point_model_template2MSR(pmt,Data);
         
        MSRshow(Data.TemplateMSR);
        NeedVolViewer=true;
        if isfield(Data,'VOL')
            if handshakeVOL(Data.VOL,10)
                NeedVolViewer=false;
            end
        end
        if NeedVolViewer
            Data=OpenVolViewer(Data);
        end
        Data.VOL=MSRshowVOL(Data.VOL,Data.TemplateMSR);
        
    elseif ~ThereIsTemplateAAM && ThereIsTemplateMSR % create AAM from MSR
        MSRshow(Data.TemplateMSR);
        Data.VOL=MSRshowVOL(Data.VOL,Data.TemplateMSR);
        
        PMTemplate=MSR2point_model_template(Data.TemplateMSR,Data)
        
        templateName = get(PMTemplate,'name');
        templatePath = ['.',filesep,get(PMTemplate,'imageDir')];        
        
        %save template
        save(fullfile(templatePath, templateName), 'PMTemplate'); 
       
        
    elseif ThereIsTemplateAAM && ThereIsTemplateMSR % invite the user to choose which is the master
        disp('There is both an AAM Template and an MSR Template, which do you wish to make the starting point')
        MSRshow(Data.TemplateMSR);
        Data.VOL=MSRshowVOL(Data.VOL,Data.TemplateMSR);
        %if AAMTemplate
        %elseif MSRTemplate
        %end
        %now allow the user to edit using VolViewer - this means loading the associated image
        
    else % create a new template using MSR
        disp('There is no existing AAM Template or MSR Template');
        %get user to select an MSR to use as a template.
        [FileName,PathName,FilterIndex] = uigetfile('*.msr','Select MSR to use as template')

        ptr = strfind(PathName, filesep);
        pn = PathName(ptr(end-1)+1:end-1)
        
        MSRobject=MSRread2Matlab(PathName,FileName);
        PMTemplate = MSR2point_model_template(MSRobject,pn);
        
        templateName = get(PMTemplate,'name');
        templatePath = ['.',filesep,get(PMTemplate,'imageDir')];
        
      
        %save template
        save(fullfile(templatePath, templateName), 'PMTemplate');
        
        

    end
        % do you want to adopt the MSR data rather than the AAM data?
    disp('To be done');
    % put the data structure back into the main work flow control window
    guidata(AAMShapemodel_figure_handle,Data);
end
