%%%%%%%%%%%%%%%%%%%%
%
% ImportSimpleShape
%
%%%%%%%%%%%%%%%%%%%%
function [handles] = ImportSimpleShape(handles)
if ~checkDir(pwd, handles)
    return;
end
imagenames = get(handles.AAM, 'imageFilenames');
I = imfinfo(['Cropped', filesep, imagenames{1}]);
[temp_path, temp_name] = get_template_info(handles.AAM);
templatedir = [pwd, filesep, temp_path, filesep, temp_name];
if ~exist(templatedir)
    return;
end
template = load(templatedir, '-mat');
template = template.PMTemplate;
[temp_path, temp_name, ext, vers] = fileparts(temp_name);

shape=questdlg('Select Shape', 'Choose Shape', 'Circle','Square','Circle');
switch lower(shape),
    case 'circle',
        I = makeCircle(I);
        saveSimpleShape([pwd, filesep, 'Cropped'], [pwd, filesep, 'PointModels', filesep, temp_name], template, I);
        disp('Making a circle');
    case 'square',
        I = makeSquare(I);
        saveSimpleShape([pwd, filesep, 'Cropped'], [pwd, filesep, 'PointModels', filesep, temp_name], template, I);
        disp('Making a square');
    otherwise
        uiwait(msgbox('Cannot make that shape yet..sorry.','Sorry','modal'));
end % switch
return;