function PMTemplate=MSR2point_model_template(MSR,pn)
    if numel(MSR.OBJECT)>1
        error(sprintf('Number of objects in MSR = %d',numel(MSR.OBJECT)))
    end
    
    pts = MSR.OBJECT{1}.VERT;
    pts = pts';
    
    primeStrings = MSR.OBJECT{1}.VERTLABEL;
    primaries = [];
    for i = 1:numel(primeStrings)
        if(strcmp(primeStrings{i},'Primary'))
            primaries(end+1) = i;
        end
    end
    
    lt = MSR.OBJECT{1}.EDGE;
    lt = lt - 1;
    loops={lt};
    %loops = '';
    
    %set other props
    templateName = [pn,'.temp_dat'];
    % Set member variables of PMTemplate object
    PMTemplate = PointModelTemplate;
    PMTemplate = set(PMTemplate, 'imageName', pn);
    PMTemplate = set(PMTemplate, 'imageDir', 'Templates');
    PMTemplate = set(PMTemplate, 'name', templateName);
    PMTemplate = set(PMTemplate, 'direc', 'Templates');
    PMTemplate = set(PMTemplate, 'pts', pts);
    PMTemplate = set(PMTemplate, 'primaries', primaries);
    PMTemplate = set(PMTemplate, 'loops', loops);
    
end