function MSR=ShowMSR(MSR,AxisH)
    if nargin<1
        filename=fullfile('D:\Shape_T1_only\Image_data\11to14DFS\1554','1554_T1_Shape.msr');
        [MSR,errs] = msrfilereader( filename );
    end
    if nargin<2
        figure(1)
        clf
        AxisH=axes;
    end
    cla(AxisH)
    hold(AxisH,'on');
    msr=MSR.OBJECT{1};
    if isfield(msr,'VERTLABEL')
        for i=1:length(msr.VERTLABEL)
            if ~isempty(msr.VERTLABEL{i})
                colour='b';
            else
                colour='r';
            end
            plot3(msr.VERT(i,1),msr.VERT(i,2),msr.VERT(i,3),'.',...
                'MarkerEdgeColor',colour,'MarkerFaceColor',colour,'tag','msr_points','parent',AxisH);
        end
    else
        plot3(msr.VERT(:,1),msr.VERT(:,2),msr.VERT(:,3),'.r','tag','msr_points','parent',AxisH);
    end
    if isfield(msr,'EDGELABEL')
        for i=1:length(msr.EDGELABEL)
            if ~isempty(msr.EDGELABEL{i})
                colour='b';
            else
                colour='r';
            end
            for i=1:size(msr.EDGE,1)
                xyz(1,:)=msr.VERT(msr.EDGE(i,1)+1,:);
                xyz(2,:)=msr.VERT(msr.EDGE(i,2)+1,:);
                plot3(xyz(:,1)',xyz(:,2)',xyz(:,3)','-','color',colour,'tag','msr_points','parent',AxisH);
            end
        end
    else
        for i=1:size(msr.EDGE,1)
            xyz(1,:)=msr.VERT(msr.EDGE(i,1)+1,:);
            xyz(2,:)=msr.VERT(msr.EDGE(i,2)+1,:);
            plot3(xyz(:,1)',xyz(:,2)',xyz(:,3)','-r','tag','msr_points','parent',AxisH);
        end
    end
end