function convertMSRfilesToPointModelFiles(MSRdir,PMdir)

%converts the MSR files in a dir to pm files

if(nargin < 2)
    MSRdir = 'E:\PAULworkspace\PRJ_ArabidopsisLeafShape\PointModels\1007gfp166_x13p11y13p11z13p11cop\MSRfiles';
    PMdir ='E:\PAULworkspace\PRJ_ArabidopsisLeafShape\PointModels\1007gfp166_x13p11y13p11z13p11cop';
end

files = dir(fullfile(MSRdir,'*.msr'));

wh = waitbar(0, 'Converting MSR to point models...');
for i = 1:numel(files)
    waitbar(i/numel(files), wh);
    %convert MSR to pm pts
    MSR=MSRread2Matlab(MSRdir,files(i).name);
    ptst = MSR.OBJECT{1}.VERT;
    
    %reshape pts to pm format
    pts = reshape(ptst',1,size(ptst,1)*size(ptst,2))';
    
    %strip out .msr from filename
    ptr = strfind(files(i).name,'.msr');
    fn = files(i).name(1:ptr(end)-1);
    
    %save pm file
    save(fullfile(PMdir,[fn,'_pm.mat']),'pts');
end
close(wh)