function [newPts] = fitSplineSmoothPts(data,interpRes,numOfPoints,debugging)
%data - xyz matrix of size (N,3) where N is the number of points
%interpRes - the resolution of the fitted spline
%numOfPoints - the number of points to be equispaced along the fitted
%spline
%funtion:
%1) fits a cubic spline through the points data.
%2) fits a number of points equispaced along the fitted spline
%Paul Southam(2012)

if(nargin < 1)
    data = [276.382685941263,0,1;
        504.070010858716,349.098057043321,2;
        670.708149845176,656.537421797942,3;
        776.297111271319,922.318027463037,4;
        790.222262982253,1115.15511653142,5;
        882.534870275978,1410.23661809837,6;
        949.422399213246,1762.00032088504,7;
        926.728511904085,2127.72907326762,8;
        822.576446610619,2407.07111597464,9;
        554.252102715814,2744.43866084022,10;
        274.437934422056,2924.21056950947,11;
        44.9789753946435,2975.52969559757,12;
        0,2869.90453895387,13;
        313.281875820092,2581.68821397722,14;];
    
    numOfPoints = 28;
    interpRes = 100;
    debugging = 1;
end

%Get the cumulative sum of distances between your points
CS = cat(1,0,cumsum(sqrt(sum(diff(data,[],1).^2,2))));
%Interpolate at 100 equally spaced locations from the start to end of your curve. Use 'spline' interpolation.
dd = interp1(CS, data, unique([CS(:)' linspace(0,CS(end),interpRes)]),'spline');

eqptsptr = round(linspace(1,size(dd,1),numOfPoints));
eqpts = dd(eqptsptr,:);
newPts = eqpts;

if(debugging)
    figure; hold on
    if(length(size(data)) == 3)
        plot3(data(:,1),data(:,2),data(:,3),'bx','markersize',15)
        plot3(dd(:,1),dd(:,2),dd(:,3),'.r-')
        plot3(eqpts(:,1),eqpts(:,2),eqpts(:,3),'go')
    else
        plot(data(:,1),data(:,2),'bx','markersize',15)
        plot(dd(:,1),dd(:,2),'.r-')
        plot(eqpts(:,1),eqpts(:,2),'go')
    end
    
    
    axis equal
    hold off
end


end