function midVeinRibThicknessGenerateModel

%user select point models
[fName,pName] = uigetfile('DialogTitle','Select Point Model Files','MultiSelect','on');

%user select connectivity file for midVeinRib - this file should be the
%loop that runs around the midvein. File name likely to be: 
% 1) midVeinLoopNoPet.csv use for no petiole or
% 2) midVeinRib.csv use to include petiole
[facetName,facetPathName] = uigetfile('DialogTitle','Select connectivity file for midVeinRib','*.csv');
midVeinRibCP = csvread([facetPathName,facetName]);


%user select connectivity file for midVeinThickness - this file is index
%around the midVeinRib file (the contents do not correspond to the original
%idexes in the point model files). Filename likely to be:
% 1) midVeinThicknessNoPet.csv for use with midVeinLoopNoPet (not model
% petiole) or
% 2) midVeinThickness.csv for use with midVeinRib.csv (modelling peitole)
[facetName2,facetPathName2] = uigetfile('DialogTitle','Select connectivity file for midToEdgeDistances','*.csv');
midToEdgeCP = csvread([facetPathName2,facetName2]);

h = waitbar(0,'Please wait...');
%for each selected pointfile
for i = 1:numel(fName)
waitbar(i / numel(fName))
%load the point file and reshape the points
if (~isa(fName,'cell'))
    pc = load([pName,fName]);
else
pc = load([pName,fName{i}]);
end
pc = pc.pts;

pts = midVeinRibThicknessModel(pc,midVeinRibCP,midToEdgeCP);

%do some scaling for display
m = min(pts(:));
pts(:,1) = pts(:,1) + (ones(size(pts,1),1) .* abs(m));

%reshape for saving
pts = reshape(pts',1,size(pts,1)*2);
pts = pts';

if (~isa(fName,'cell'))
tmp = fName;
else
    tmp = fName{i};
end
mkdir([pName,'VEINRIBTHICKNESS',filesep]);
save([pName,'VEINRIBTHICKNESS',filesep,tmp],'pts');

end
close(h)


end