function [filenames] = calculate_group_appearance_means(prj_details, templatename)
cropped_dir = 'Cropped';
pointmodels_dir = 'PointModels';
filenames = {};
indx = 1;
for i=1:length(prj_details)
    proj_list = prj_details{i};
    for ii=1:length(proj_list)
        proj_temp = proj_list(ii);
        template_name = proj_temp.temp_name;
        if strcmp(template_name, templatename)==1
            pm_files = proj_temp.pmfiles;
            prj_name = proj_temp.prj_name;
            X = [];
            filename = [pointmodels_dir, filesep, proj_temp.temp_name, filesep, 'MEAN_TEMPLATE_', proj_temp.temp_name, '_', proj_temp.prj_name, '_pm.mat'];
            if exist(filename)
                Xm = load(filename);
                Xm = Xm.pts';
                Xm = (reshape(Xm, 2, length(Xm)/2))';
                for iii=1:length(pm_files)
                    imagename = pm_files{iii};
                    imagename = [imagename(1:end-7), '.jpg'];
                    img = imread([cropped_dir, filesep, prj_name, '_', imagename]);
                    pts = load([pointmodels_dir, filesep, template_name, filesep, prj_name, '_', pm_files{iii}]);
                    pts = pts.pts';
                    pts = (reshape(pts, 2, length(pts)/2))';
                    [wimg] = triwarp(img, pts, Xm, []);
                    if isempty(X)
                        X = double(wimg(:));
                    else
                        X = X + double(wimg(:));
                    end
                end
                X = X./length(pm_files);
                X = mean(X,2);
                X = uint8(reshape(X, size(wimg)));
                filename = [cropped_dir, filesep, 'MEAN_TEMPLATE_', proj_temp.temp_name, '_', proj_temp.prj_name, '.jpg'];
                fprintf('Saving mean appearance for project %s and template %s to \n%s\n', proj_temp.prj_name, proj_temp.temp_name, filename);
                imwrite(X, filename);
                [pathname, filename, ext, vers] = fileparts(filename);
                filenames{indx} = [filename, ext];
                indx = indx + 1;
            end
        end
    end
end




