function [prj_details] = calculate_group_shape_means(prj_details, templatename)
point_models_dir = 'PointModels';
cropped_images_dir = 'Cropped';
for i=1:length(prj_details)
    proj_list = prj_details{i};
    for ii=1:length(proj_list)
        proj_temp = proj_list(ii);
        template_name = proj_temp.temp_name;
        if strcmp(template_name, templatename)==1
            pm_files = proj_temp.pmfiles;
            prj_name = proj_temp.prj_name;
            [X] = load_group_pointmodels(template_name, pm_files, prj_name);
            [xaligned, proc_alignment] = pmalign(X, [1 1 1]);
            Xm = mean(xaligned');
            pts = Xm(:);
            filename = [point_models_dir, filesep, proj_temp.temp_name, filesep, 'MEAN_TEMPLATE_', proj_temp.temp_name, '_', proj_temp.prj_name, '_pm.mat'];
            fprintf('Saving mean shape for project %s to \n%s\n', proj_temp.prj_name, filename);
            save(filename, 'pts');
        end
    end
end







