%%%
%
%
%%%
function found = construct_project_directories(handles, project_directory)
found = 0;
if ~exist(project_directory, 'dir');
    mkdir(project_directory);
else
    str = sprintf('A project with this name already exists.\nSwitching to that project');
    uiwait(msgbox(str,'Sorry','modal'));
    found = 1;
    return;
end;
if ~exist([project_directory, filesep, 'Original'], 'dir'); mkdir([project_directory, filesep, 'Original']); end;
if ~exist([project_directory, filesep, 'Cropped'], 'dir'); mkdir([project_directory, filesep, 'Cropped']); end;
if ~exist([project_directory, filesep, 'Templates'], 'dir'); mkdir([project_directory, filesep, 'Templates']); end;
if ~exist([project_directory, filesep, 'PointModels'], 'dir'); mkdir([project_directory, filesep, 'PointModels']); end;
if ~exist([project_directory, filesep, 'StatisticalModels'], 'dir'); mkdir([project_directory, filesep, 'StatisticalModels']); end;
if ~exist([project_directory, filesep, 'Groups'], 'dir'); mkdir([project_directory, filesep, 'Groups']); end;
cd(project_directory);
if ~checkDir(project_directory, handles)
    error('Could not create directory structure properly please contact the administrator for AAMToolbox');
end
return