function pdm = getPdm(modeldir)
% function pdm = getPdm(modeldir)
%
% Returns the pdm for model in modeldir from disk
%
% Dr. A. I. Hanna
pdm = [];
if nargin~=1
    fprintf('Usage: pdm = getPdm(modeldir)\n');
    return;
end
pdmfilename = [modeldir, filesep, 'mod_pdm.mat'];
if ~exist(pdmfilename)
    fprintf('Non-existant filename - %s\n', pmdfilename);
    return;
end
pdm = load(pdmfilename);
if ~isfield(pdm, 'pdm');
    fprintf('not a valid pdm\n');
    return;
end
pdm = pdm.pdm;
