function shapematrix2excell
% function shapematrix2excell
%
% This is a simple script that asks the user for a Shape Matrix file and
% then converts that file to an excel file for input to gen-spring or some
% other classification tool.
%
% related: extract_shape_PC_data, exportModelData, AAMToolbox
%
% Dr. A. I. Hanna (2006)
[filename, pathname] = uigetfile('*.mat', 'Pick a Shape Matrix file');
if isequal(filename,0) || isequal(pathname,0)
    disp('User pressed cancel');
    return;
end

disp(['User selected ', fullfile(pathname, filename)]);

shapemat = load([pathname, filesep, filename]);

if ~isfield(shapemat, 'shape_pc_values')
    str = sprintf('Invalid shape matrix file. Try clicking ''Export Shape PC Matrix''\nfrom the Project menu');
    uiwait(msgbox(str,'Invalid file','modal'));
    return;
end
[xlsfilename, xlspathname] = uiputfile('*.xls', 'Save as...');
if isequal(xlsfilename,0) || isequal(xlspathname,0)
    disp('User pressed cancel');
    return;
end
PCs = shapemat.PCs;
shapemat = shapemat.shape_pc_values;
sheet1 = {};
sheet2 = {};
for i=1:length(PCs)
    sheet1{1, i+1} = PCs(i);
    sheet2{1, i+1} = PCs(i);
end
for i=1:length(shapemat)
    sheet1{i+1,1} = shapemat(i).filename;
    sheet2{i+1,1} = shapemat(i).filename;
    pcvals = shapemat(i).pc_values;
    stdpcvals = shapemat(i).std_pc_values;
    for j=1:size(pcvals,1)
        sheet1{i+1, j+1} = pcvals(j,1); 
        sheet2{i+1, j+1} = stdpcvals(j,1); 
    end
end
[success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet1, 'PC Vals Variance');
[success, message] = xlswrite([xlspathname, filesep, xlsfilename], sheet2, 'PC Vals Std');
return;