function [pts] = trans_rot_points(pts, offset, theta)
% function [pts] = trans_rot_points(pts, offset, theta)
%
% This function takes a NxD shape where N is the number of points in the
% shape and D is the dimension of the shape, together with a translation
% and an angle, the function returns the translated and rotated shape.
%
% See also: splitPoints, isAugmentedProject
%
% Dr. A. I. Hanna (2007)
mu = mean(pts,2);
pts = pts - mu*ones(1, size(pts,2));
R = [cos(theta) -sin(theta); sin(theta) cos(theta)];
pts = R*pts;
pts = pts + mu*ones(1, size(pts,2));
pts = pts + offset*ones(1, size(pts,2));
