% function template2DTo3D()

%% Load the 2D point template

[filename, pathname] = uigetfile('.temp_dat');

if ~isequal(filename, 0) && ~isequal(pathname, 0)
    
    t = load(fullfile(pathname, filename), '-mat');
    PMTemplate = t.PMTemplate;
end

%% Optionally load the adjusted 3D point set

[filename, pathname] = uigetfile('.pts');

if ~isequal(filename, 0) && ~isequal(pathname, 0)
    
    p = load(fullfile(pathname, filename), '-mat');
    points3D = p.points;
end

%% Change the template

name = 'leaf53_3D.temp_dat';

PMTemplate = set(PMTemplate, 'imageName', '672clippedA128Cubed');
PMTemplate = set(PMTemplate, 'imageDir', 'Templates');
PMTemplate = set(PMTemplate, 'name', name);
% PMTemplate = set(PMTemplate, 'primaries', []);

% Cannot set loops to [] as ViewStatsModel falls over, other tools are ok
% PMTemplate = set(PMTemplate, 'loops', []);
image = get(PMTemplate, 'image');

% An empty matrix as the image data causes the ModelBuilder to fall over
% Keeping a dummy matrix is only required for the 3D template used in a 
% 2D test project. This template was named leaf53_2D.temp_dat
image = [];
% image(:, :, :) = 0;
% image = zeros(1, 1, 3);

PMTemplate = set(PMTemplate, 'image', image);
PMTemplate = set(PMTemplate, 'pts', points3D);

save(name, 'PMTemplate');
