%%%
%
%
%%%
function [pmfiles, pointmodel] = getPMList(projectdir, template)
[temppath, templatename, ext, vers] = fileparts(template);
pointmodel = [projectdir, filesep, 'PointModels', filesep, templatename];
files = dir([pointmodel, filesep, '*_pm.mat']);
files = {files.name};
waitbar_h = waitbar(0, sprintf('Copying point models\nfor template %s.', templatename));
set(findall(waitbar_h,'type','text'),'Interpreter','none')
M = length(files);
for i=1:M
    waitbar(i/M,waitbar_h)
    pmfiles(i).filename = files{i};
    pmfilename = [pointmodel, filesep, files{i}];
    if exist(pmfilename)
        pts = load(pmfilename);
        pts = pts.pts;
    else
        pts = [];
    end
    pmfiles(i).pts = pts;
end
close(waitbar_h);
return;
