function AllPointSets=DiscoverPointSets(modelDirec)
    % function AllPointSets=DiscoverPointSets(modelDirec)
    % work through the StatisticalModels directory
    % finding subdirectories associated with each model template
    % and within these finding the sets of models
    % and within each of these use the indices.mat and LN_*.mat
    % files to capture the subset of points
    %
    %AllPointSets, structure array of set names and indices
    %
    %J. Andrew Bangham, 2010
    d=dir(modelDirec);
    templatemodels={d(3:end).name};
    for i=1:length(templatemodels)
        templatemodel=templatemodels{i};
        directory=fullfile(modelDirec,templatemodel);
        if exist(directory)==7
            pointSetdirectories=dir(directory);
            pointSetnames={pointSetdirectories(3:end).name};
            %pointSets=struct(length(setnames));
            for j=1:length(pointSetnames)
                s=dir(fullfile(directory,pointSetnames{j},'LN*'));
                AllPointSets(j).pointSetDirectory=pointSetnames{j};
                AllPointSets(j).name=s(1).name(4:end-4);
                indicesFilename=fullfile(directory,pointSetnames{j},'indices.mat');
                n=load(indicesFilename,'-mat');
                if isfield(n,'setlist')
                    indices=n.setlist;
                else
                    indices=n.indices;
                end
                AllPointSets(j).indices=indices;
            end
        end
    end
end
