function sheet3 = constructSheet3(model)
sheet3 = {};

% Project Stuff
projectname = pwd;
[projectdir, projectname, ext, vers] = fileparts(projectname);
sheet3{end+1, 1} = 'Project Name';
sheet3{end, 2} = projectname;
sheet3{end+1, 1} = 'Project Directory';
sheet3{end, 2} = projectdir;
sheet3{end+1, 1} = '';

modelDir = get(model, 'modelDirec');

groupsfilename = [pwd, filesep, modelDir, filesep, 'groups.mat'];
if exist(groupsfilename)
    groups = load(groupsfilename, '-mat');
    groups = groups.groups;
end
for i=1:length(groups)
    group = groups(i);
    elements = group.elements;
    sheet3{end+1, 1} = 'Group Name';
    sheet3{end, 2} = group.name;
    sheet3{end+1, 1} = 'Colour';
    sheet3{end, 2} = num2str(group.color);
    sheet3{end+1, 1} = 'Point Models';
    for ii=1:length(elements)
        sheet3{end+1, 2} = elements{ii};
    end
end
return;
