function midVeinRibGenerateModels

%user select point models
[fName,pName] = uigetfile('DialogTitle','Select Point Model Files','MultiSelect','on');

%user select connectivity file
[facetName,facetPathName] = uigetfile('DialogTitle','Select connectivity file','*.csv');

connectedPts = csvread([facetPathName,facetName]);

h = waitbar(0,'Please wait...');
%for each selected pointfile
for i = 1:numel(fName)
waitbar(i / numel(fName))
%load the point file and reshape the points
if (~isa(fName,'cell'))
    pc = load([pName,fName]);
else
pc = load([pName,fName{i}]);
end
pc = pc.pts;

pts = midVeinRibViaPlaneModel(pc,connectedPts);

%do some scaling for display
m = min(pts(:));
pts(:,1) = pts(:,1) + (ones(size(pts,1),1) .* abs(m));

%reshape for saving
pts = reshape(pts',1,size(pts,1)*2);
pts = pts';

if (~isa(fName,'cell'))
tmp = fName;
else
    tmp = fName{i};
end
mkdir([pName,'VEINRIB',filesep]);
save([pName,'VEINRIB',filesep,tmp],'pts');

end
close(h)

end