function P = gen_rectangular_data(N)
if nargin<1
    N = 100;
end
for i=1:N
    anis = .5+ rand(1,1)/10;
    theta = randn(1,1)/(10);
    r = makerectangle(2, anis, [0;0]+rand(2,1), theta)';
    P(:,i) = r(:);
end
plotshapes(P);
return;

function [p] = makerectangle(w, anis, c, theta)
c = c(:);
p = c;
l = anis*w;
p = [p, c + [-w; -l]];
p = [p, c + [w; -l]];
p = [p, c + [w; l]];
p = [p, c + [-w; l]];
R = [cos(theta), -sin(theta); sin(theta) cos(theta)];
p = R*p;

function plotshapes(P)
figure(1); clf;
hold on;
for i=1:size(P,2)
    r = P(:,i);
    r = reshape(r, length(r)/2,2);
    plot(r(:,1), r(:,2), 'o');
end