function newmodel = midVeinRibThicknessModel(oldPts,connectedPts,connectedPts2)

debugPlot = 0;

midVeinRibPlaneModel = midVeinRibViaPlaneModel(oldPts,connectedPts);

%find the midLinePts
leftEdgeIdxs = connectedPts2(:,1,:);
rightEdgeIdxs = connectedPts2(:,3,:);

for i = 1:size(connectedPts2,1)-1
    midLinePts(i,:) = (midVeinRibPlaneModel(leftEdgeIdxs(i),:)+ midVeinRibPlaneModel(rightEdgeIdxs(i),:))./2
end

if(debugPlot)
    figure;
    plot(midVeinRibPlaneModel(:,1),midVeinRibPlaneModel(:,2),'rx');    
    axis equal
    hold on
    plot(midLinePts(:,1),midLinePts(:,2),'bo');
end

%add the midLinePts to the midVeinRibPlaneModel points
compositePts = [midVeinRibPlaneModel;midLinePts];

%% calculate the midvein distances
midVeinIdxs = connectedPts2(:,2,:);
for i = 1:size(connectedPts2,1)-1
    midVeinDistances(i,:) = sqrt(sum(abs(compositePts(midVeinIdxs(i),:) - compositePts(midVeinIdxs(i+1),:)).^2));
end
%% calculate the left edge to midvein distances
leftEdgeIdxs = connectedPts2(:,1,:);
for i = 1:size(connectedPts2,1)-1
    leftEdgeDistances(i,:) = sqrt(sum(abs(compositePts(midVeinIdxs(i),:) - compositePts(leftEdgeIdxs(i),:)).^2));
end
%% calculate the right edge to midvein distances
rightEdgeIdxs = connectedPts2(:,3,:);
for i = 1:size(connectedPts2,1)-1
    rightEdgeDistances(i,:) = sqrt(sum(abs(compositePts(midVeinIdxs(i),:) - compositePts(rightEdgeIdxs(i),:)).^2));
end

%% SIMPLE MODEL
%replot pts
newModelDataM = [0,0];
for i = 1:size(midVeinDistances,1)
    newModelDataM(i+1,2) = newModelDataM(i,2)+ midVeinDistances(i,:);
end
newModelDataL = [leftEdgeDistances,newModelDataM(1:end-1,2)];
newModelDataR = [-rightEdgeDistances,newModelDataM(1:end-1,2)];

newModel = [newModelDataL;newModelDataR;newModelDataM];

if(debugPlot)
    figure;
    plot(newModel(:,1),newModel(:,2),'rx');
    axis equal
end



end