function midVeinRibPerpThicknessGenerateModels(arg)

%user select point models
[fName,pName] = uigetfile('DialogTitle','Select Point Model Files','MultiSelect','on');

if nargin < 1
    %user select connectivity file for midVeinRib
    [facetName,facetPathName] = uigetfile('DialogTitle','Select connectivity file for midVeinPerpRib','*.csv');
    midVeinRibCP = csvread([facetPathName,facetName]);
    
    %user select connectivity file for midToEdgeDistances
    [facetName2,facetPathName2] = uigetfile('DialogTitle','Select connectivity file for midVeinRibPerpThickness','*.csv');
    midToEdgeCP = csvread([facetPathName2,facetName2]);
else
    switch arg
        case 'auto'
            midVeinRibCP = csvread(which('midVeinPerpRib.csv'));
            midToEdgeCP = csvread(which('midVeinRibPerpThickness.csv'));
        otherwise
            %user select connectivity file for midVeinRib
            [facetName,facetPathName] = uigetfile('DialogTitle','Select connectivity file for midVeinPerpRib','*.csv');
            midVeinRibCP = csvread([facetPathName,facetName]);
            
            %user select connectivity file for midToEdgeDistances
            [facetName2,facetPathName2] = uigetfile('DialogTitle','Select connectivity file for midVeinRibPerpThickness','*.csv');
            midToEdgeCP = csvread([facetPathName2,facetName2]);
    end
end


h = waitbar(0,'Please wait...');
%for each selected pointfile
for i = 1:numel(fName)
waitbar(i / numel(fName))
%load the point file and reshape the points
if (~isa(fName,'cell'))
    pc = load([pName,fName]);
else
pc = load([pName,fName{i}]);
end
pc = pc.pts;

pts = midVeinRibPerpThicknessModel(pc,midVeinRibCP,midToEdgeCP);

%do some scaling for display
m = min(pts(:));
pts(:,1) = pts(:,1) + (ones(size(pts,1),1) .* abs(m));

%reshape for saving
pts = reshape(pts',1,size(pts,1)*2);
pts = pts';

if (~isa(fName,'cell'))
tmp = fName;
else
    tmp = fName{i};
end
mkdir([pName,'VEINRIBPERPTHICKNESS',filesep]);
save([pName,'VEINRIBPERPTHICKNESS',filesep,tmp],'pts');

end
close(h)


end