/*
 * Decompiled with CFR 0.152.
 */
package com.arc.swing;

import com.arc.awt.event.ProgressListener;
import com.arc.swing.action.AbstractStandardAction;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public abstract class JProgressDialog
extends JDialog
implements ProgressListener {
    protected AbstractStandardAction CancelAction;
    protected boolean DialogCancelEnabled;
    protected ActionEvent DialogEvent;
    protected JLabel DialogText;
    protected volatile boolean ThreadRunning;
    protected volatile boolean ThreadCancelled;

    protected void buildActions() {
        this.CancelAction = new AbstractStandardAction("Cancel", null, KeyStroke.getKeyStroke(27, 0), 1){

            @Override
            public void actionPerformed(ActionEvent e) {
                JProgressDialog.this.CancelAction(e);
            }
        };
    }

    protected void buildLayout() {
        this.setResizable(false);
        JPanel MainPanel = new JPanel(){
            Dimension Size = new Dimension();

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(JProgressDialog.this.DialogCancelEnabled ? 400 : 300, super.getPreferredSize().height);
                return this.Size;
            }
        };
        MainPanel.setLayout(new GridBagLayout());
        MainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        JPanel TopPanel = new JPanel(){
            Dimension Size = new Dimension();

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(new Color(250, 230, 160));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(super.getPreferredSize().width, 10);
                return this.Size;
            }
        };
        TopPanel.setAlignmentX(0.0f);
        GridBagConstraints d = new GridBagConstraints();
        d.gridy = 0;
        d.gridwidth = 2;
        d.weightx = 1.0;
        d.weighty = 0.0;
        d.fill = 2;
        MainPanel.add((Component)TopPanel, d);
        JProgressBar Progress = new JProgressBar();
        Progress.setAlignmentX(0.0f);
        Progress.setIndeterminate(true);
        d.gridy = 1;
        d.gridwidth = 2;
        d.weightx = 1.0;
        d.weighty = 0.0;
        d.fill = 2;
        MainPanel.add((Component)Progress, d);
        JPanel BottomPanel = new JPanel(){
            Dimension Size = new Dimension();

            @Override
            public void paintComponent(Graphics g) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setColor(new Color(250, 230, 160));
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            }

            @Override
            public Dimension getPreferredSize() {
                this.Size.setSize(super.getPreferredSize().width, 10);
                return this.Size;
            }
        };
        BottomPanel.setAlignmentX(0.0f);
        d.gridy = 2;
        d.gridwidth = 2;
        d.weightx = 1.0;
        d.weighty = 0.0;
        d.fill = 2;
        MainPanel.add((Component)BottomPanel, d);
        JPanel TextPanel = new JPanel();
        TextPanel.setLayout(new GridBagLayout());
        TextPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        d.gridy = 0;
        d.gridwidth = 1;
        d.weightx = 1.0;
        d.weighty = 0.0;
        d.fill = 2;
        TextPanel.add((Component)this.DialogText, d);
        d.gridy = 3;
        d.gridwidth = 1;
        d.weightx = 1.0;
        d.weighty = 0.0;
        d.fill = 2;
        MainPanel.add((Component)TextPanel, d);
        if (this.DialogCancelEnabled) {
            JPanel ButtonPanel = new JPanel();
            ButtonPanel.setLayout(new GridBagLayout());
            ButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            d.gridy = 0;
            d.gridwidth = 1;
            d.weightx = 1.0;
            d.weighty = 0.0;
            d.fill = 2;
            this.CancelAction.addManagedButton(ButtonPanel, d, true, false);
            d.gridx = 1;
            d.gridy = 3;
            d.gridwidth = 1;
            d.weightx = 0.0;
            d.weighty = 0.0;
            d.fill = 0;
            MainPanel.add((Component)ButtonPanel, d);
        }
        this.getContentPane().add(MainPanel);
    }

    protected void dialogOpened(WindowEvent e) {
        final Thread actionThread = new Thread(){

            @Override
            public void run() {
                if (!JProgressDialog.this.ThreadRunning) {
                    JProgressDialog.this.ThreadRunning = true;
                    JProgressDialog.this.actionPerformed(JProgressDialog.this.DialogEvent, JProgressDialog.this);
                    JProgressDialog.this.dispose();
                    JProgressDialog.this.ThreadRunning = false;
                }
            }
        };
        if (this.DialogCancelEnabled) {
            Thread CancelMonitorThread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    actionThread.start();
                    try {
                        while (actionThread.isAlive() && !JProgressDialog.this.ThreadCancelled) {
                            actionThread.join(500L);
                        }
                    }
                    catch (Exception Ex) {
                        JProgressDialog.this.ThreadCancelled = true;
                    }
                    finally {
                        if (JProgressDialog.this.isDisplayable()) {
                            JProgressDialog.this.hide();
                        }
                    }
                }
            };
            CancelMonitorThread.start();
        } else {
            actionThread.start();
        }
    }

    protected void CancelAction(ActionEvent e) {
        if (this.DialogCancelEnabled) {
            this.DialogText.setText("Cancelling.");
            this.ThreadCancelled = true;
            Timer CancelTextTimer = new Timer(50, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JProgressDialog.this.DialogText.setText(JProgressDialog.this.DialogText.getText() + ".");
                }
            });
            CancelTextTimer.setRepeats(true);
            CancelTextTimer.start();
        }
    }

    public JProgressDialog(JFrame newOwnerFrame, String newTitle, boolean newValue) {
        super(newOwnerFrame, newTitle, true);
        this.DialogText = new JLabel(newTitle);
        this.DialogCancelEnabled = newValue;
        this.ThreadCancelled = false;
        this.ThreadRunning = false;
        this.DialogEvent = null;
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                JProgressDialog.this.dialogOpened(e);
            }
        });
        this.buildActions();
        this.buildLayout();
    }

    @Override
    public void show() {
        this.setDialogEvent(null);
        this.pack();
        int DialogWidth = this.getWidth();
        int DialogHeight = this.getHeight();
        int WindowWidth = this.getParent().getWidth();
        int WindowHeight = this.getParent().getHeight();
        Point WindowPos = this.getParent().getLocation();
        int DialogPosX = (WindowWidth - DialogWidth) / 2 + WindowPos.x;
        int DialogPosY = (WindowHeight - DialogHeight) / 2 + WindowPos.y;
        this.setLocation(DialogPosX, DialogPosY);
        this.CancelAction.registerAccelerator(this.getRootPane(), 1);
        super.show();
        this.CancelAction.unregisterAccelerator(this.getRootPane(), 1);
    }

    public void show(ActionEvent newActionEvent) {
        this.setDialogEvent(newActionEvent);
        this.pack();
        int DialogWidth = this.getWidth();
        int DialogHeight = this.getHeight();
        int WindowWidth = this.getParent().getWidth();
        int WindowHeight = this.getParent().getHeight();
        Point WindowPos = this.getParent().getLocation();
        int DialogPosX = (WindowWidth - DialogWidth) / 2 + WindowPos.x;
        int DialogPosY = (WindowHeight - DialogHeight) / 2 + WindowPos.y;
        this.setLocation(DialogPosX, DialogPosY);
        this.CancelAction.registerAccelerator(this.getRootPane(), 1);
        super.show();
        this.CancelAction.unregisterAccelerator(this.getRootPane(), 1);
    }

    public void setDialogEvent(ActionEvent newActionEvent) {
        this.DialogEvent = newActionEvent;
    }

    public ActionEvent getDialogEvent() {
        return this.DialogEvent;
    }

    public boolean progressEvent(final String newUpdateMessage) {
        if (!this.ThreadCancelled) {
            if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JProgressDialog.this.DialogText.setText(newUpdateMessage);
                    }
                });
            } else {
                this.DialogText.setText(newUpdateMessage);
            }
            return true;
        }
        return false;
    }

    public boolean progressEvent(String newUpdateMessage, int newValue) {
        return true;
    }

    public void pushProgressRange(int newMinValue, int newMaxValue, int newTimeout) {
    }

    public void popProgressRange() {
    }

    public boolean progressEvent(int newValue) {
        return true;
    }

    public int getProgressValue() {
        return 0;
    }

    public String getProgressMessage() {
        return this.DialogText.getText();
    }

    public abstract void actionPerformed(ActionEvent var1, JProgressDialog var2);
}

