/*
 * Decompiled with CFR 0.152.
 */
package com.arc.swing.action;

import com.arc.swing.JToolbarButton;
import com.arc.swing.action.ActionDescriptor;
import com.arc.swing.util.Threads;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;

public abstract class AbstractStandardAction {
    public static final int ACTION_THREADED = 0;
    public static final int ACTION_NON_THREADED = 1;
    protected static final Map<AbstractButton, AbstractStandardAction> ButtonActionMap = Collections.synchronizedMap(new HashMap());
    protected static Class DefaultStandardButtonClass = JToolbarButton.class;
    protected int Type;
    protected List<AbstractButton> ButtonList;
    protected Map<Container, AbstractButton> ManagedButtonMap;
    protected AbstractAction ActionParameters;

    protected void actionInterceptor(final ActionEvent actionEvent) {
        switch (this.Type) {
            case 0: {
                Thread actionThread = new Thread(){

                    @Override
                    public void run() {
                        AbstractStandardAction.this.actionPerformed(actionEvent);
                    }
                };
                actionThread.start();
                break;
            }
            default: {
                this.actionPerformed(actionEvent);
            }
        }
    }

    public AbstractStandardAction(String newName, String newTip, Icon newIcon, KeyStroke newAccelerator, int newMnemonic, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newTip);
        this.ActionParameters.putValue("AcceleratorKey", newAccelerator);
        this.ActionParameters.putValue("MnemonicKey", new Integer(newMnemonic));
    }

    public AbstractStandardAction(String newName, Icon newIcon, KeyStroke newAccelerator, int newMnemonic, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newName);
        this.ActionParameters.putValue("AcceleratorKey", newAccelerator);
        this.ActionParameters.putValue("MnemonicKey", new Integer(newMnemonic));
    }

    public AbstractStandardAction(String newName, String newTip, Icon newIcon, KeyStroke newAccelerator, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newTip);
        this.ActionParameters.putValue("AcceleratorKey", newAccelerator);
    }

    public AbstractStandardAction(String newName, Icon newIcon, KeyStroke newAccelerator, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newName);
        this.ActionParameters.putValue("AcceleratorKey", newAccelerator);
    }

    public AbstractStandardAction(String newName, String newTip, Icon newIcon, int newMnemonic, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newTip);
        this.ActionParameters.putValue("MnemonicKey", new Integer(newMnemonic));
    }

    public AbstractStandardAction(String newName, Icon newIcon, int newMnemonic, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newName);
        this.ActionParameters.putValue("MnemonicKey", new Integer(newMnemonic));
    }

    public AbstractStandardAction(String newName, String newTip, Icon newIcon, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newTip);
    }

    public AbstractStandardAction(String newName, Icon newIcon, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newIcon != null ? new AbstractAction(newName, newIcon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newName){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        this.ActionParameters.putValue("ShortDescription", newName);
    }

    public AbstractStandardAction(ActionDescriptor newDescriptor, int newType) {
        this.Type = newType;
        this.ManagedButtonMap = Collections.synchronizedMap(new HashMap());
        this.ButtonList = Collections.synchronizedList(new ArrayList());
        this.ActionParameters = newDescriptor.Icon != null ? new AbstractAction(newDescriptor.Name, newDescriptor.Icon){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        } : new AbstractAction(newDescriptor.Name){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractStandardAction.this.actionInterceptor(actionEvent);
            }
        };
        if (newDescriptor.Tip != null) {
            this.ActionParameters.putValue("ShortDescription", newDescriptor.Tip);
        }
        if (newDescriptor.Accelerator != null) {
            this.ActionParameters.putValue("AcceleratorKey", newDescriptor.Accelerator);
        }
        if (newDescriptor.Mnemonic != 0) {
            this.ActionParameters.putValue("MnemonicKey", new Integer(newDescriptor.Mnemonic));
        }
    }

    public void setLongDescription(String newLongDescription) {
        this.ActionParameters.putValue("LongDescription", newLongDescription);
    }

    public String getLongDescription() {
        return (String)this.ActionParameters.getValue("LongDescription");
    }

    public void setEnabled(boolean newValue) {
        this.ActionParameters.setEnabled(newValue);
    }

    public boolean isEnabled() {
        return this.ActionParameters.isEnabled();
    }

    public void doClick() {
        if (this.ButtonList.size() > 0) {
            this.ButtonList.get(0).doClick();
        }
    }

    public void addManagedButton(Class newButtonClass, Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                AbstractButton newButton = (AbstractButton)newButtonClass.newInstance();
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((JComponent)newButton, (Container)newContainer, (Object)newConstraints);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, newConstraints, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, Class[] newButtonArgsClasses, Object[] newButtonArgs, Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                Constructor ButtonConstructor = newButtonClass.getConstructor(newButtonArgsClasses);
                AbstractButton newButton = (AbstractButton)ButtonConstructor.newInstance(newButtonArgs);
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((JComponent)newButton, (Container)newContainer, (Object)newConstraints);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(8, (int)mnemonic), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, newConstraints, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, int newIndex, Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                AbstractButton newButton = (AbstractButton)newButtonClass.newInstance();
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((int)newIndex, (JComponent)newButton, (Container)newContainer, (Object)newConstraints);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, newConstraints, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, Class[] newButtonArgsClasses, Object[] newButtonArgs, int newIndex, Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                Constructor ButtonConstructor = newButtonClass.getConstructor(newButtonArgsClasses);
                AbstractButton newButton = (AbstractButton)ButtonConstructor.newInstance(newButtonArgs);
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((int)newIndex, (JComponent)newButton, (Container)newContainer, (Object)newConstraints);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, newConstraints, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, Container newContainer, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                AbstractButton newButton = (AbstractButton)newButtonClass.newInstance();
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((Component)newButton, (Container)newContainer);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, Class[] newButtonArgsClasses, Object[] newButtonArgs, Container newContainer, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                Constructor ButtonConstructor = newButtonClass.getConstructor(newButtonArgsClasses);
                AbstractButton newButton = (AbstractButton)ButtonConstructor.newInstance(newButtonArgs);
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((Component)newButton, (Container)newContainer);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, int newIndex, Container newContainer, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                AbstractButton newButton = (AbstractButton)newButtonClass.newInstance();
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((int)newIndex, (Component)newButton, (Container)newContainer);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, showText, showIcon);
        }
    }

    public void addManagedButton(Class newButtonClass, Class[] newButtonArgsClasses, Object[] newButtonArgs, int newIndex, Container newContainer, boolean showText, boolean showIcon) {
        try {
            if (!this.ManagedButtonMap.containsKey(newContainer)) {
                Integer mnemonic;
                Constructor ButtonConstructor = newButtonClass.getConstructor(newButtonArgsClasses);
                AbstractButton newButton = (AbstractButton)ButtonConstructor.newInstance(newButtonArgs);
                this.registerButton(newButton, showText, showIcon);
                this.ManagedButtonMap.put(newContainer, newButton);
                Threads.safeAddComponent((int)newIndex, (Component)newButton, (Container)newContainer);
                if ((newContainer instanceof JMenu || newContainer instanceof JPopupMenu) && (mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey")) != null) {
                    ((JComponent)newContainer).getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                    ((JComponent)newContainer).getActionMap().put("Name", this.ActionParameters);
                }
            }
        }
        catch (Exception Ex) {
            this.addManagedButton(newContainer, showText, showIcon);
        }
    }

    public void addManagedButton(Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        this.addManagedButton(DefaultStandardButtonClass, newContainer, newConstraints, showText, showIcon);
    }

    public void addManagedButton(int newIndex, Container newContainer, Object newConstraints, boolean showText, boolean showIcon) {
        this.addManagedButton(DefaultStandardButtonClass, newIndex, newContainer, newConstraints, showText, showIcon);
    }

    public void addManagedButton(Container newContainer, boolean showText, boolean showIcon) {
        this.addManagedButton(DefaultStandardButtonClass, newContainer, showText, showIcon);
    }

    public void addManagedButton(int newIndex, Container newContainer, boolean showText, boolean showIcon) {
        this.addManagedButton(DefaultStandardButtonClass, newIndex, newContainer, showText, showIcon);
    }

    public void addManagedMenuItem(JMenu newMenu) {
        if (!this.ManagedButtonMap.containsKey(newMenu)) {
            JMenuItem newMenuItem = new JMenuItem();
            this.registerButton(newMenuItem, true, true);
            this.ManagedButtonMap.put(newMenu, newMenuItem);
            Threads.safeAddComponent((Component)newMenuItem, (Container)newMenu);
            Integer mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey");
            if (mnemonic != null) {
                newMenu.getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                newMenu.getActionMap().put("Name", this.ActionParameters);
            }
        }
    }

    public void addManagedMenuItem(int newIndex, JMenu newMenu) {
        if (!this.ManagedButtonMap.containsKey(newMenu)) {
            JMenuItem newMenuItem = new JMenuItem();
            this.registerButton(newMenuItem, true, true);
            this.ManagedButtonMap.put(newMenu, newMenuItem);
            Threads.safeAddComponent((int)newIndex, (Component)newMenuItem, (Container)newMenu);
            Integer mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey");
            if (mnemonic != null) {
                newMenu.getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                newMenu.getActionMap().put("Name", this.ActionParameters);
            }
        }
    }

    public void addManagedMenuItem(JPopupMenu newMenu) {
        if (!this.ManagedButtonMap.containsKey(newMenu)) {
            JMenuItem newMenuItem = new JMenuItem();
            this.registerButton(newMenuItem, true, true);
            this.ManagedButtonMap.put(newMenu, newMenuItem);
            Threads.safeAddComponent((Component)newMenuItem, (Container)newMenu);
            Integer mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey");
            if (mnemonic != null) {
                newMenu.getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                newMenu.getActionMap().put("Name", this.ActionParameters);
            }
        }
    }

    public void addManagedMenuItem(int newIndex, JPopupMenu newMenu) {
        if (!this.ManagedButtonMap.containsKey(newMenu)) {
            JMenuItem newMenuItem = new JMenuItem();
            this.registerButton(newMenuItem, true, true);
            this.ManagedButtonMap.put(newMenu, newMenuItem);
            Threads.safeAddComponent((int)newIndex, (Component)newMenuItem, (Container)newMenu);
            Integer mnemonic = (Integer)this.ActionParameters.getValue("MnemonicKey");
            if (mnemonic != null) {
                newMenu.getInputMap(0).put(KeyStroke.getKeyStroke(mnemonic, 8), "Name");
                newMenu.getActionMap().put("Name", this.ActionParameters);
            }
        }
    }

    public void removeManagedComponent(Container newContainer) {
        if (this.ManagedButtonMap.containsKey(newContainer)) {
            AbstractButton newButton = this.ManagedButtonMap.get(newContainer);
            this.unregisterButton(newButton);
            Threads.safeRemoveComponent((JComponent)newButton, (Container)newContainer);
        }
        this.ManagedButtonMap.remove(newContainer);
    }

    public void removeAllManagedComponents() {
        Iterator<Container> ContainerIterator = this.ManagedButtonMap.keySet().iterator();
        for (int i = 0; i < this.ManagedButtonMap.size(); ++i) {
            Container CurrentContainer = ContainerIterator.next();
            AbstractButton newButton = this.ManagedButtonMap.get(CurrentContainer);
            this.unregisterButton(newButton);
            Threads.safeRemoveComponent((JComponent)newButton, (Container)CurrentContainer);
        }
        this.ManagedButtonMap.clear();
    }

    public void removeAllManagedComponents(Class newClass) {
        Iterator<Container> ContainerIterator = this.ManagedButtonMap.keySet().iterator();
        for (int i = 0; i < this.ManagedButtonMap.size(); ++i) {
            Container CurrentContainer = ContainerIterator.next();
            AbstractButton newButton = this.ManagedButtonMap.get(CurrentContainer);
            if (!newButton.getClass().equals(newClass)) continue;
            this.unregisterButton(newButton);
            Threads.safeRemoveComponent((JComponent)newButton, (Container)CurrentContainer);
        }
        this.ManagedButtonMap.clear();
    }

    public void removeAllManagedButtonComponents() {
        Iterator<Container> ContainerIterator = this.ManagedButtonMap.keySet().iterator();
        for (int i = 0; i < this.ManagedButtonMap.size(); ++i) {
            Container CurrentContainer = ContainerIterator.next();
            AbstractButton newButton = this.ManagedButtonMap.get(CurrentContainer);
            if (newButton instanceof JMenuItem) continue;
            this.unregisterButton(newButton);
            Threads.safeRemoveComponent((JComponent)newButton, (Container)CurrentContainer);
            this.ManagedButtonMap.remove(CurrentContainer);
        }
    }

    public void removeAllManagedMenuItemComponents() {
        Iterator<Container> ContainerIterator = this.ManagedButtonMap.keySet().iterator();
        for (int i = 0; i < this.ManagedButtonMap.size(); ++i) {
            Container CurrentContainer = ContainerIterator.next();
            AbstractButton newButton = this.ManagedButtonMap.get(CurrentContainer);
            if (!(newButton instanceof JMenuItem)) continue;
            this.unregisterButton(newButton);
            Threads.safeRemoveComponent((JComponent)newButton, (Container)CurrentContainer);
            this.ManagedButtonMap.remove(CurrentContainer);
        }
    }

    public void registerButton(AbstractButton newButton, boolean showText, boolean showIcon) {
        if (ButtonActionMap.containsKey(newButton)) {
            ButtonActionMap.get(newButton).unregisterButton(newButton);
        }
        this.ButtonList.add(newButton);
        ButtonActionMap.put(newButton, this);
        newButton.setAction(this.ActionParameters);
        newButton.setToolTipText((String)this.ActionParameters.getValue("ShortDescription"));
        if (!showText) {
            newButton.setText("");
        }
        if (!showIcon) {
            newButton.setIcon(null);
        }
    }

    public void unregisterButton(AbstractButton newButton) {
        newButton.setAction(null);
        this.ButtonList.remove(newButton);
        ButtonActionMap.remove(newButton);
    }

    public void registerAccelerator(JComponent newKey, int newScope) {
        newKey.getInputMap(newScope).put((KeyStroke)this.ActionParameters.getValue("AcceleratorKey"), this.ActionParameters.getValue("Name"));
        newKey.getActionMap().put(this.ActionParameters.getValue("Name"), this.ActionParameters);
    }

    public void unregisterAccelerator(JComponent newKey, int newScope) {
        newKey.getInputMap(newScope).remove((KeyStroke)this.ActionParameters.getValue("AcceleratorKey"));
        newKey.getActionMap().remove(this.ActionParameters.getValue("AcceleratorKey"));
    }

    public void requestFocus(Container newContainer) {
        if (this.ManagedButtonMap.containsKey(newContainer)) {
            AbstractButton b = this.ManagedButtonMap.get(newContainer);
            b.requestFocus();
        } else {
            for (AbstractButton Button : this.ButtonList) {
                if (!newContainer.isAncestorOf(Button) || !Button.isFocusable()) continue;
                Button.requestFocus();
                break;
            }
        }
    }

    public abstract void actionPerformed(ActionEvent var1);
}

