/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine;

import com.Fo2PiX.blendengine.BlendEngineByteBufferScratch;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;

public abstract class BlendEngineBufferScratch {
    protected RandomAccessFile Scratch;
    protected FileChannel ScratchChannel;
    protected DataBuffer TrgtDBfr;
    protected Rectangle TrgtRect;

    public static long writeScratch(FileChannel newChannel, Rectangle newTrgtRect, DataBuffer newTrgtDBfr) throws IOException {
        switch (newTrgtDBfr.getDataType()) {
            case 0: {
                return BlendEngineByteBufferScratch.writeByteScratch(newChannel, newTrgtRect, (DataBufferByte)newTrgtDBfr);
            }
        }
        throw new IOException("Unsupported Image Format");
    }

    public static long readScratch(FileChannel newChannel, Rectangle newTrgtRect, DataBuffer newTrgtDBfr) throws IOException {
        switch (newTrgtDBfr.getDataType()) {
            case 0: {
                return BlendEngineByteBufferScratch.readByteScratch(newChannel, newTrgtRect, (DataBufferByte)newTrgtDBfr);
            }
        }
        throw new IOException("Unsupported Image Format");
    }

    public static BlendEngineBufferScratch getScratch(File newScratch, Rectangle newTrgtRect, DataBuffer newTrgtDBfr) throws IOException {
        switch (newTrgtDBfr.getDataType()) {
            case 0: {
                return new BlendEngineByteBufferScratch(newScratch, newTrgtRect, newTrgtDBfr);
            }
        }
        throw new IOException("Unsupported Image Format");
    }

    public static BlendEngineBufferScratch getScratch(File newScratch, Rectangle newTrgtRect, DataBuffer newTrgtDBfr, FileChannel newChannel, long newCount) throws IOException {
        switch (newTrgtDBfr.getDataType()) {
            case 0: {
                return new BlendEngineByteBufferScratch(newScratch, newTrgtRect, newTrgtDBfr, newChannel, newCount);
            }
        }
        throw new IOException("Unsupported Image Format");
    }

    public BlendEngineBufferScratch(File newScratch, Rectangle newTrgtRect, DataBuffer newTrgtDBfr) throws IOException {
        this.Scratch = new RandomAccessFile(newScratch, "rwd");
        this.ScratchChannel = this.Scratch.getChannel();
        this.TrgtRect = newTrgtRect;
        this.TrgtDBfr = newTrgtDBfr;
    }

    public abstract void put(int var1) throws IOException;

    public abstract void get(int var1) throws IOException;

    public abstract void clear(int var1) throws IOException;

    public abstract void clearAll() throws IOException;

    public abstract void transfer(BlendEngineBufferScratch var1, long var2) throws IOException;

    public abstract void transfer(FileChannel var1) throws IOException;

    public abstract long getStoreSize();

    public abstract void close();
}

