/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine;

import com.Fo2PiX.blendengine.BlendEngineBufferScratch;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;

class BlendEngineByteBufferScratch
extends BlendEngineBufferScratch {
    protected ByteBuffer[] TrgtBfrs;
    protected int TrgtBfrCnt;
    protected int TrgtBfrSz;
    protected int ScrtchBfrSz;

    public static long writeByteScratch(FileChannel newChannel, Rectangle newTrgtRect, DataBufferByte newTrgtDBfr) throws IOException {
        byte[][] TrgtDBfrBnkData = newTrgtDBfr.getBankData();
        int TrgtBfrCnt = TrgtDBfrBnkData.length;
        ByteBuffer[] TrgtBfrs = new ByteBuffer[TrgtDBfrBnkData.length];
        for (int i = 0; i < TrgtBfrCnt; ++i) {
            TrgtBfrs[i] = ByteBuffer.wrap(TrgtDBfrBnkData[i]);
        }
        return newChannel.write(TrgtBfrs);
    }

    public static long readByteScratch(FileChannel newChannel, Rectangle newTrgtRect, DataBufferByte newTrgtDBfr) throws IOException {
        byte[][] TrgtDBfrBnkData = newTrgtDBfr.getBankData();
        int TrgtBfrCnt = TrgtDBfrBnkData.length;
        ByteBuffer[] TrgtBfrs = new ByteBuffer[TrgtDBfrBnkData.length];
        for (int i = 0; i < TrgtBfrCnt; ++i) {
            TrgtBfrs[i] = ByteBuffer.wrap(TrgtDBfrBnkData[i]);
        }
        return newChannel.read(TrgtBfrs);
    }

    BlendEngineByteBufferScratch(File newScratch, Rectangle newTrgtRect, DataBuffer newTrgtDBfr) throws IOException {
        super(newScratch, newTrgtRect, newTrgtDBfr);
        byte[][] TrgtDBfrBnkData = ((DataBufferByte)this.TrgtDBfr).getBankData();
        this.TrgtBfrCnt = TrgtDBfrBnkData.length;
        this.TrgtBfrs = new ByteBuffer[TrgtDBfrBnkData.length];
        this.TrgtBfrSz = TrgtDBfrBnkData[0].length;
        for (int i = 0; i < this.TrgtBfrCnt; ++i) {
            this.TrgtBfrs[i] = ByteBuffer.wrap(TrgtDBfrBnkData[i]);
        }
        this.ScrtchBfrSz = this.TrgtBfrCnt * this.TrgtBfrSz;
    }

    BlendEngineByteBufferScratch(File newScratch, Rectangle newTrgtRect, DataBuffer newTrgtDBfr, FileChannel newChannel, long newCount) throws IOException {
        super(newScratch, newTrgtRect, newTrgtDBfr);
        byte[][] TrgtDBfrBnkData = ((DataBufferByte)this.TrgtDBfr).getBankData();
        this.TrgtBfrCnt = TrgtDBfrBnkData.length;
        this.TrgtBfrs = new ByteBuffer[TrgtDBfrBnkData.length];
        this.TrgtBfrSz = TrgtDBfrBnkData[0].length;
        for (int i = 0; i < this.TrgtBfrCnt; ++i) {
            this.TrgtBfrs[i] = ByteBuffer.wrap(TrgtDBfrBnkData[i]);
        }
        this.ScrtchBfrSz = this.TrgtBfrCnt * this.TrgtBfrSz;
        System.out.println("Transferring from position " + newChannel.position() + " " + newCount + " Bytes");
        System.out.println("Transferred " + this.ScratchChannel.transferFrom(newChannel, 0L, newCount));
    }

    @Override
    public void put(int newPos) throws IOException {
        for (int i = 0; i < this.TrgtBfrCnt; ++i) {
            System.out.println("Writing ByteBuffer " + i + " at " + (newPos * this.ScrtchBfrSz + i * this.TrgtBfrSz));
            System.out.println("Wrote " + this.ScratchChannel.write(this.TrgtBfrs[i], newPos * this.ScrtchBfrSz + i * this.TrgtBfrSz) + " Bytes");
            this.TrgtBfrs[i].clear();
        }
    }

    @Override
    public void get(int newPos) throws IOException {
        for (int i = 0; i < this.TrgtBfrCnt; ++i) {
            System.out.println("Reading ByteBuffer " + i + " from " + (newPos * this.ScrtchBfrSz + i * this.TrgtBfrSz));
            System.out.println("Read " + this.ScratchChannel.read(this.TrgtBfrs[i], newPos * this.ScrtchBfrSz + i * this.TrgtBfrSz) + " Bytes");
            this.TrgtBfrs[i].clear();
        }
    }

    @Override
    public void clear(int newPos) throws IOException {
    }

    @Override
    public void clearAll() throws IOException {
    }

    @Override
    public void transfer(BlendEngineBufferScratch newScratch, long newPos) throws IOException {
        if (newScratch instanceof BlendEngineByteBufferScratch) {
            BlendEngineByteBufferScratch Target = (BlendEngineByteBufferScratch)newScratch;
            for (int i = 0; i < Target.TrgtBfrCnt; ++i) {
                System.out.println("Reading ByteBuffer " + i + " from " + (newPos * (long)this.ScrtchBfrSz + (long)(i * this.TrgtBfrSz)));
                System.out.println("Read " + Target.ScratchChannel.transferFrom(this.ScratchChannel, newPos * (long)this.ScrtchBfrSz + (long)(i * this.TrgtBfrSz), this.ScrtchBfrSz) + " Bytes");
            }
        } else {
            throw new IOException();
        }
    }

    @Override
    public void transfer(FileChannel newChannel) throws IOException {
        System.out.println("Transferring to position " + newChannel.position() + " " + this.ScratchChannel.size() + " Bytes");
        System.out.println("Transferred " + this.ScratchChannel.transferTo(0L, this.ScratchChannel.size(), newChannel) + " Bytes");
    }

    @Override
    public long getStoreSize() {
        try {
            return this.ScratchChannel.size();
        }
        catch (Exception Ex) {
            System.out.println("Invalid Channel Size");
            return 0L;
        }
    }

    @Override
    public void close() {
        try {
            this.ScratchChannel.close();
            this.Scratch.close();
        }
        catch (Exception Ex) {
            System.out.println("True comedy error: Failed to close the file because it failed to close the file!");
            Ex.printStackTrace();
        }
    }
}

