/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors;

import com.Fo2PiX.blendengine.imageprocessors.BlndProcessors;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.FldFllProcessors;
import com.Fo2PiX.blendengine.imageprocessors.GryScleProcessors;
import com.Fo2PiX.blendengine.imageprocessors.HueSatProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import com.Fo2PiX.blendengine.imageprocessors.TrnsProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgrb.BGRbBlndProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgrb.BGRbBrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgrb.BGRbFldFllProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgrb.BGRbHueSatProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgrb.BGRbTrnsProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiBlndStaticProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiBrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiFldFllProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiGryScleProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiHueSatProcessors;
import com.Fo2PiX.blendengine.imageprocessors.bgri.BGRiTrnsProcessors;
import com.Fo2PiX.blendengine.imageprocessors.m.MBrtnsCtrstStaticProcessors;
import com.Fo2PiX.blendengine.imageprocessors.m.MTrnsStaticProcessors;
import java.io.IOException;

public class ImageProcessorFactory {
    public static final int TRNS_INVRT = 1;
    public static final int TRNS_FLPX = 2;
    public static final int TRNS_FLPY = 4;
    public static final int COLOUR_MODEL_BGRB = 0;
    public static final int COLOUR_MODEL_M = 1;
    public static final int COLOUR_MODEL_BGRI = 2;
    public static final int BLND_PureClr = 0;
    public static final int BLND_SftLt = 1;
    public static final int BLND_SftLtHrdLt = 2;
    public static final int BLND_HrdLt = 3;
    public static final int BLND_HrdLtIdnty = 4;
    public static final int BLND_Idnty = 5;
    public static final int BLND_IdntyMult = 6;
    public static final int BLND_Mult = 7;
    public static final int BLND_MultScrn = 8;
    public static final int BLND_Scrn = 9;
    public static final int BLND_PureVal = 10;
    public static final int GRYSCLE_COPY = 0;
    public static final int GRYSCLE_LINIER = 1;
    public static final int GRYSCLE_NTSC = 2;

    public static void loadLookupTables() throws IOException, ClassNotFoundException {
        ImageProcessorTables.loadLookupTables();
    }

    public static HueSatProcessors getHueSatProcessor(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return new BGRbHueSatProcessors();
            }
            case 1: {
                return null;
            }
            case 2: {
                return new BGRiHueSatProcessors();
            }
        }
        return new BGRbHueSatProcessors();
    }

    public static BrtnsCtrstProcessors getBrtnsCtrstProcessor(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return new BGRbBrtnsCtrstProcessors();
            }
            case 1: {
                return new MBrtnsCtrstStaticProcessors();
            }
            case 2: {
                return new BGRiBrtnsCtrstProcessors();
            }
        }
        return new BGRbBrtnsCtrstProcessors();
    }

    public static TrnsProcessors getTrnsProcessor(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return new BGRbTrnsProcessors();
            }
            case 1: {
                return new MTrnsStaticProcessors();
            }
            case 2: {
                return new BGRiTrnsProcessors();
            }
        }
        return new BGRbTrnsProcessors();
    }

    public static FldFllProcessors getFldFllProcessor(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return new BGRbFldFllProcessors();
            }
            case 2: {
                return new BGRiFldFllProcessors();
            }
        }
        return null;
    }

    public static BlndProcessors getBlndProcessor(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return new BGRbBlndProcessors();
            }
            case 2: {
                return new BGRiBlndStaticProcessors();
            }
        }
        return null;
    }

    public static GryScleProcessors getGryScleProcessors(int newColourModel) {
        switch (newColourModel) {
            case 0: {
                return null;
            }
            case 2: {
                return new BGRiGryScleProcessors();
            }
        }
        return null;
    }
}

