/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgrb;

import com.Fo2PiX.blendengine.imageprocessors.BlndProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BlndProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import com.arc.awt.event.ProgressListener;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRbBlndProcessors
implements BlndProcessors {
    private final BlndProcessor[] BlndPs = new BlndProcessor[]{new AlgnPureClrProcessor(), new AlgnSftLtProcessor(), new AlgnSftLtHrdLtProcessor(), new AlgnHrdLtProcessor(), new AlgnHrdLtIdntyProcessor(), new AlgnIdntyProcessor(), new AlgnIdntyMultProcessor(), new AlgnMultProcessor(), new AlgnMultScrnProcessor(), new AlgnScrnProcessor()};
    private final double[][] BlndCoeffLookup = new double[256][101];
    private final double[] ClrCoeffLookup = new double[256];
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte BlndCnvsDB = null;
    protected DataBufferByte FxdCnvsDB = null;
    protected byte[] SelMskB = null;
    protected byte[] SrcRdB = null;
    protected byte[] SrcGnB = null;
    protected byte[] SrcBlB = null;
    protected byte[] BlndCnvsRdB = null;
    protected byte[] BlndCnvsGnB = null;
    protected byte[] BlndCnvsBlB = null;
    protected byte[] FxdCnvsRdB = null;
    protected byte[] FxdCnvsGnB = null;
    protected byte[] FxdCnvsBlB = null;
    protected int SrcWidth = 0;
    protected int SrcHeight = 0;
    protected int CnvsWidth = 0;
    protected int CnvsHeight = 0;

    public BGRbBlndProcessors() {
        for (int i = 0; i < 256; ++i) {
            this.ClrCoeffLookup[i] = (double)i / 255.0;
            for (int j = 0; j < 101; ++j) {
                this.BlndCoeffLookup[i][j] = (double)i / 255.0 * ((double)j / 100.0);
            }
        }
    }

    public void setTrgts(Rectangle SrcSize, DataBuffer Src, Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer Cnvs, ProgressListener newProgressProc) {
        this.SrcDB = (DataBufferByte)Src;
        this.BlndCnvsDB = (DataBufferByte)Cnvs;
        this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
        this.SrcRdB = this.SrcDB.getData(0);
        this.SrcGnB = this.SrcDB.getData(1);
        this.SrcBlB = this.SrcDB.getData(2);
        this.BlndCnvsRdB = this.BlndCnvsDB.getData(0);
        this.BlndCnvsGnB = this.BlndCnvsDB.getData(1);
        this.BlndCnvsBlB = this.BlndCnvsDB.getData(2);
        this.FxdCnvsRdB = this.FxdCnvsDB.getData(0);
        this.FxdCnvsGnB = this.FxdCnvsDB.getData(1);
        this.FxdCnvsBlB = this.FxdCnvsDB.getData(2);
        this.SrcWidth = SrcSize.width;
        this.SrcHeight = SrcSize.height;
        this.CnvsWidth = CnvsSize.width;
        this.CnvsHeight = CnvsSize.height;
    }

    public void setSelMskTrgt(Rectangle MskSize, DataBuffer Msk, ProgressListener newProgressProc) {
    }

    @Override
    public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
        this.SrcDB = (DataBufferByte)Src;
        this.SrcRdB = this.SrcDB.getData(0);
        this.SrcGnB = this.SrcDB.getData(1);
        this.SrcBlB = this.SrcDB.getData(2);
        this.SrcWidth = SrcSize.width;
        this.SrcHeight = SrcSize.height;
    }

    @Override
    public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
    }

    @Override
    public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
        this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
        this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
        this.BlndCnvsRdB = this.BlndCnvsDB.getData(0);
        this.BlndCnvsGnB = this.BlndCnvsDB.getData(1);
        this.BlndCnvsBlB = this.BlndCnvsDB.getData(2);
        this.FxdCnvsRdB = this.FxdCnvsDB.getData(0);
        this.FxdCnvsGnB = this.FxdCnvsDB.getData(1);
        this.FxdCnvsBlB = this.FxdCnvsDB.getData(2);
        this.CnvsWidth = CnvsSize.width;
        this.CnvsHeight = CnvsSize.height;
    }

    @Override
    public BlndProcessor getBlndProcessor(int BlndProcess) {
        return this.BlndPs[BlndProcess];
    }

    class AlgnScrnProcessor
    implements BlndProcessor {
        AlgnScrnProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF];
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * ((BlndSrcRdd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * ((BlndSrcGnd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * ((BlndSrcBld + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF];
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * ((BlndSrcRdd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * ((BlndSrcGnd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * ((BlndSrcBld + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnMultScrnProcessor
    implements BlndProcessor {
        AlgnMultScrnProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF];
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF];
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnMultProcessor
    implements BlndProcessor {
        AlgnMultProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnIdntyMultProcessor
    implements BlndProcessor {
        AlgnIdntyMultProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcRdB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcGnB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcBlB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcRdB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcGnB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)(BGRbBlndProcessors.this.SrcBlB[si] & 0xFF) + MnrCoef * (BGRbBlndProcessors.this.ClrCoeffLookup[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF] * BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnIdntyProcessor
    implements BlndProcessor {
        AlgnIdntyProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcRdB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF));
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcGnB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF));
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcBlB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF));
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcRdB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF));
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcGnB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF));
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)(BGRbBlndProcessors.this.SrcBlB[si] & 0xFF) + cf1 * (double)(BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF));
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnHrdLtIdntyProcessor
    implements BlndProcessor {
        AlgnHrdLtIdntyProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsRdB[ci]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsGnB[ci]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsBlB[ci]);
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsRdB[ci]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsGnB[ci]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsBlB[ci]);
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnHrdLtProcessor
    implements BlndProcessor {
        AlgnHrdLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnSftLtHrdLtProcessor
    implements BlndProcessor {
        AlgnSftLtHrdLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsRdB[ci]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsGnB[ci]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsBlB[ci]);
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        double FxdCnvsRdd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRbBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRbBlndProcessors.this.SrcRdB[si] & 0xFF;
                        int BlndSrcGni = BGRbBlndProcessors.this.SrcGnB[si] & 0xFF;
                        int BlndSrcBli = BGRbBlndProcessors.this.SrcBlB[si] & 0xFF;
                        double BlndSrcRdd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRbBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsRdB[ci]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsGnB[ci]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)BGRbBlndProcessors.this.FxdCnvsBlB[ci]);
                        }
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnSftLtProcessor
    implements BlndProcessor {
        AlgnSftLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class AlgnPureClrProcessor
    implements BlndProcessor {
        AlgnPureClrProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int y = 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = 0;
            while (y < BGRbBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c;
                while (x < BGRbBlndProcessors.this.CnvsWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double m00 = ColSrcTrns[0];
            double m10 = ColSrcTrns[1];
            double m01 = ColSrcTrns[2];
            double m11 = ColSrcTrns[3];
            double m02 = ColSrcTrns[4];
            double m12 = ColSrcTrns[5];
            int si = 0;
            double cf1 = 0.0;
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            SelWidth = SelWidth + SelX > BGRbBlndProcessors.this.CnvsWidth ? BGRbBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRbBlndProcessors.this.CnvsHeight ? BGRbBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double m11y = (double)y * m11;
            double m01y = (double)y * m01;
            int c = SelY * BGRbBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double m00x = (double)x * m00;
                double m10x = (double)x * m10;
                int ci = c + SelX;
                while (x < SelWidth) {
                    int x1 = (int)(m00x + m01y + m02 + 0.5);
                    int y1 = (int)(m10x + m11y + m12 + 0.5);
                    double cf0 = BGRbBlndProcessors.this.BlndCoeffLookup[BGRbBlndProcessors.this.SelMskB[ci] & 0xFF][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || x1 < BGRbBlndProcessors.this.SrcWidth && x1 >= 0 && y1 < BGRbBlndProcessors.this.SrcHeight && y1 >= 0)) {
                        cf1 = 1.0 - cf0;
                        si = (y1 + BGRbBlndProcessors.this.SrcHeight) % BGRbBlndProcessors.this.SrcHeight * BGRbBlndProcessors.this.SrcWidth + (x1 + BGRbBlndProcessors.this.SrcWidth) % BGRbBlndProcessors.this.SrcWidth;
                        int FxdCnvsRdi = BGRbBlndProcessors.this.FxdCnvsRdB[ci] & 0xFF;
                        int FxdCnvsGni = BGRbBlndProcessors.this.FxdCnvsGnB[ci] & 0xFF;
                        int FxdCnvsBli = BGRbBlndProcessors.this.FxdCnvsBlB[ci] & 0xFF;
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRbBlndProcessors.this.SrcRdB[si] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRbBlndProcessors.this.SrcGnB[si] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRbBlndProcessors.this.SrcBlB[si] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRbBlndProcessors.this.BlndCnvsRdB[ci] = BGRbBlndProcessors.this.FxdCnvsRdB[ci];
                        BGRbBlndProcessors.this.BlndCnvsGnB[ci] = BGRbBlndProcessors.this.FxdCnvsGnB[ci];
                        BGRbBlndProcessors.this.BlndCnvsBlB[ci] = BGRbBlndProcessors.this.FxdCnvsBlB[ci];
                    }
                    m00x = (double)(++x) * m00;
                    m10x = (double)x * m10;
                    ci = c + x;
                }
                m11y = (double)(++y) * m11;
                m01y = (double)y * m01;
                c = y * BGRbBlndProcessors.this.CnvsWidth;
            }
        }
    }
}

