/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgrb;

import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRbBrtnsCtrstProcessors
implements BrtnsCtrstProcessors {
    private final BrtnsCtrstProcessor BrtnsCtrstCpy = new RGBbBrtnsCtrstCpyImpl();
    private final BrtnsCtrstProcessor BrtnsCtrst0_50 = new RGBbBrtnsCtrst0_50Impl();
    private final BrtnsCtrstProcessor BrtnsCtrst50_100 = new RGBbBrtnsCtrst50_100Impl();
    private final BrtnsCtrstProcessor BrtnsCtrstThhld = new RGBbBrtnsCtrstThhldImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcRdB = null;
    protected byte[] SrcGnB = null;
    protected byte[] SrcBlB = null;
    protected byte[] DstRdB = null;
    protected byte[] DstGnB = null;
    protected byte[] DstBlB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcRdB = this.SrcDB.getData(0);
        this.SrcGnB = this.SrcDB.getData(1);
        this.SrcBlB = this.SrcDB.getData(2);
        this.DstRdB = this.DstDB.getData(0);
        this.DstGnB = this.DstDB.getData(1);
        this.DstBlB = this.DstDB.getData(2);
    }

    @Override
    public BrtnsCtrstProcessor getBrtnsCtrstProcessor(int Val, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            return this.BrtnsCtrstCpy;
        }
        if (Brtns > 1.88) {
            return this.BrtnsCtrstThhld;
        }
        if (Ctrst < 50.0) {
            return this.BrtnsCtrst0_50;
        }
        return this.BrtnsCtrst50_100;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            this.BrtnsCtrstCpy.processImage(Brtns, Ctrst);
        } else if (Brtns > 1.85) {
            this.BrtnsCtrstThhld.processImage(Brtns, Ctrst);
        } else if (Ctrst < 50.0) {
            this.BrtnsCtrst0_50.processImage(Brtns, Ctrst);
        } else {
            this.BrtnsCtrst50_100.processImage(Brtns, Ctrst);
        }
    }

    class RGBbBrtnsCtrstThhldImpl
    implements BrtnsCtrstProcessor {
        RGBbBrtnsCtrstThhldImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int threshold = 255 - (int)(Ctrst / 100.0 * 255.0);
            for (int i = 0; i < BGRbBrtnsCtrstProcessors.this.SrcRdB.length; ++i) {
                if ((BGRbBrtnsCtrstProcessors.this.SrcRdB[i] & 0xFF) < threshold && (BGRbBrtnsCtrstProcessors.this.SrcGnB[i] & 0xFF) < threshold && (BGRbBrtnsCtrstProcessors.this.SrcBlB[i] & 0xFF) < threshold) {
                    BGRbBrtnsCtrstProcessors.this.DstRdB[i] = 0;
                    BGRbBrtnsCtrstProcessors.this.DstGnB[i] = 0;
                    BGRbBrtnsCtrstProcessors.this.DstBlB[i] = 0;
                    continue;
                }
                BGRbBrtnsCtrstProcessors.this.DstRdB[i] = -1;
                BGRbBrtnsCtrstProcessors.this.DstGnB[i] = -1;
                BGRbBrtnsCtrstProcessors.this.DstBlB[i] = -1;
            }
        }
    }

    class RGBbBrtnsCtrst50_100Impl
    implements BrtnsCtrstProcessor {
        RGBbBrtnsCtrst50_100Impl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma50_100[(int)Ctrst];
            for (int i = 0; i < BGRbBrtnsCtrstProcessors.this.SrcRdB.length; ++i) {
                BGRbBrtnsCtrstProcessors.this.DstRdB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRbBrtnsCtrstProcessors.this.SrcRdB[i] & 0xFF]));
                BGRbBrtnsCtrstProcessors.this.DstGnB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRbBrtnsCtrstProcessors.this.SrcGnB[i] & 0xFF]));
                BGRbBrtnsCtrstProcessors.this.DstBlB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRbBrtnsCtrstProcessors.this.SrcBlB[i] & 0xFF]));
            }
        }
    }

    class RGBbBrtnsCtrst0_50Impl
    implements BrtnsCtrstProcessor {
        RGBbBrtnsCtrst0_50Impl() {
        }

        @Override
        public final void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma0_50[(int)Ctrst];
            for (int i = 0; i < BGRbBrtnsCtrstProcessors.this.SrcRdB.length; ++i) {
                BGRbBrtnsCtrstProcessors.this.DstRdB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRbBrtnsCtrstProcessors.this.SrcRdB[i] & 0xFF]));
                BGRbBrtnsCtrstProcessors.this.DstGnB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRbBrtnsCtrstProcessors.this.SrcGnB[i] & 0xFF]));
                BGRbBrtnsCtrstProcessors.this.DstBlB[i] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRbBrtnsCtrstProcessors.this.SrcBlB[i] & 0xFF]));
            }
        }
    }

    class RGBbBrtnsCtrstCpyImpl
    implements BrtnsCtrstProcessor {
        RGBbBrtnsCtrstCpyImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            System.arraycopy(BGRbBrtnsCtrstProcessors.this.SrcRdB, 0, BGRbBrtnsCtrstProcessors.this.DstRdB, 0, BGRbBrtnsCtrstProcessors.this.SrcRdB.length);
            System.arraycopy(BGRbBrtnsCtrstProcessors.this.SrcGnB, 0, BGRbBrtnsCtrstProcessors.this.DstGnB, 0, BGRbBrtnsCtrstProcessors.this.SrcGnB.length);
            System.arraycopy(BGRbBrtnsCtrstProcessors.this.SrcBlB, 0, BGRbBrtnsCtrstProcessors.this.DstBlB, 0, BGRbBrtnsCtrstProcessors.this.SrcBlB.length);
        }
    }
}

