/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.BlndProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BlndProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiBlndProcessors
implements BlndProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final BlndProcessor[] BlndPs = new BlndProcessor[]{new PureClrProcessor(), new SftLtProcessor(), new SftLtHrdLtProcessor(), new HrdLtProcessor(), new HrdLtIdntyProcessor(), new IdntyProcessor(), new IdntyMultProcessor(), new MultProcessor(), new MultScrnProcessor(), new ScrnProcessor(), new PureValProcessor()};
    private final double[][] BlndCoeffLookup = new double[256][101];
    private final double[] ClrCoeffLookup = new double[256];
    protected DataBufferByte SelMskDB = null;
    protected DataBufferByte ColSrcDB = null;
    protected DataBufferByte StnclSrcDB = null;
    protected DataBufferByte BlndCnvsDB = null;
    protected DataBufferByte FxdCnvsDB = null;
    protected byte[] SelMskB = null;
    protected byte[] ColSrcB = null;
    protected byte[] StnclSrcB = null;
    protected byte[] BlndCnvsB = null;
    protected byte[] FxdCnvsB = null;
    protected int ColSrcWidth = 0;
    protected int ColSrcHeight = 0;
    protected int StnclSrcWidth = 0;
    protected int StnclSrcHeight = 0;
    protected int CnvsWidth = 0;
    protected int CnvsHeight = 0;

    public BGRiBlndProcessors() {
        for (int i = 0; i < 256; ++i) {
            this.ClrCoeffLookup[i] = (double)i / 255.0;
            for (int j = 0; j < 101; ++j) {
                this.BlndCoeffLookup[i][j] = (double)i / 255.0 * ((double)j / 100.0);
            }
        }
    }

    @Override
    public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
        this.ColSrcDB = (DataBufferByte)Src;
        this.ColSrcB = this.ColSrcDB.getData(0);
        this.ColSrcWidth = SrcSize.width;
        this.ColSrcHeight = SrcSize.height;
    }

    @Override
    public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
        this.StnclSrcDB = (DataBufferByte)Src;
        this.StnclSrcB = this.StnclSrcDB.getData(0);
        this.StnclSrcWidth = SrcSize.width;
        this.StnclSrcHeight = SrcSize.height;
    }

    @Override
    public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
        this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
        this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
        this.BlndCnvsB = this.BlndCnvsDB.getData(0);
        this.FxdCnvsB = this.FxdCnvsDB.getData(0);
        this.SelMskDB = (DataBufferByte)SelMsk;
        this.SelMskB = this.SelMskDB.getData(0);
        this.CnvsWidth = CnvsSize.width;
        this.CnvsHeight = CnvsSize.height;
    }

    @Override
    public BlndProcessor getBlndProcessor(int BlndProcess) {
        return this.BlndPs[BlndProcess];
    }

    class PureValProcessor
    implements BlndProcessor {
        PureValProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double FxdCnvsRdi = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                        double FxdCnvsGni = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                        double FxdCnvsBli = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                        double H = (double)0.596f * FxdCnvsRdi + (double)-0.274f * FxdCnvsGni + (double)-0.322f * FxdCnvsBli;
                        double S = (double)0.211f * FxdCnvsRdi + (double)-0.523f * FxdCnvsGni + (double)0.312f * FxdCnvsBli;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                        double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                        double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                        R = Math.max(R, 0.0);
                        G = Math.max(G, 0.0);
                        B = Math.max(B, 0.0);
                        if (R > 1.0 || G > 1.0 || B > 1.0) {
                            double temp = Math.max(Math.max(R, G), B);
                            R /= temp;
                            G /= temp;
                            B /= temp;
                        }
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double FxdCnvsRdi = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                        double FxdCnvsGni = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                        double FxdCnvsBli = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                        double H = (double)0.596f * FxdCnvsRdi + (double)-0.274f * FxdCnvsGni + (double)-0.322f * FxdCnvsBli;
                        double S = (double)0.211f * FxdCnvsRdi + (double)-0.523f * FxdCnvsGni + (double)0.312f * FxdCnvsBli;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                        double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                        double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                        R = Math.max(R, 0.0);
                        G = Math.max(G, 0.0);
                        B = Math.max(B, 0.0);
                        if (R > 1.0 || G > 1.0 || B > 1.0) {
                            double temp = Math.max(Math.max(R, G), B);
                            R /= temp;
                            G /= temp;
                            B /= temp;
                        }
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class ScrnProcessor
    implements BlndProcessor {
        ScrnProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((BlndSrcRdd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((BlndSrcGnd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((BlndSrcBld + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((BlndSrcRdd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((BlndSrcGnd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((BlndSrcBld + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class MultScrnProcessor
    implements BlndProcessor {
        MultScrnProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class MultProcessor
    implements BlndProcessor {
        MultProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class IdntyMultProcessor
    implements BlndProcessor {
        IdntyMultProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * mp10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) + MnrCoef * (BGRiBlndProcessors.this.ClrCoeffLookup[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF] * BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class IdntyProcessor
    implements BlndProcessor {
        IdntyProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF));
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF));
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF));
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF));
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF));
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) + cf1 * (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF));
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class HrdLtIdntyProcessor
    implements BlndProcessor {
        HrdLtIdntyProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class HrdLtProcessor
    implements BlndProcessor {
        HrdLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class SftLtHrdLtProcessor
    implements BlndProcessor {
        SftLtHrdLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = BGRiBlndProcessors.this.ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = BGRiBlndProcessors.this.ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)BGRiBlndProcessors.this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class SftLtProcessor
    implements BlndProcessor {
        SftLtProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        int FxdCnvsRdi = BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF;
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }

    class PureClrProcessor
    implements BlndProcessor {
        PureClrProcessor() {
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < BGRiBlndProcessors.this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < BGRiBlndProcessors.this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        if (V >= 0.04 && V < 0.98) {
                            double H = (double)0.596f * CnvsRdi + (double)-0.274f * CnvsGni + (double)-0.322f * CnvsBli;
                            double S = (double)0.211f * CnvsRdi + (double)-0.523f * CnvsGni + (double)0.312f * CnvsBli;
                            double FxdCnvsRdi = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                            double FxdCnvsGni = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                            double FxdCnvsBli = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                            V = (double)0.299f * FxdCnvsRdi + (double)0.587f * FxdCnvsGni + (double)0.114f * FxdCnvsBli;
                            double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                            double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                            double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                            R = Math.max(R, 0.0);
                            G = Math.max(G, 0.0);
                            B = Math.max(B, 0.0);
                            if (R > 1.0 || G > 1.0 || B > 1.0) {
                                double temp = Math.max(Math.max(R, G), B);
                                R /= temp;
                                G /= temp;
                                B /= temp;
                            }
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                        } else {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > BGRiBlndProcessors.this.CnvsWidth ? BGRiBlndProcessors.this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > BGRiBlndProcessors.this.CnvsHeight ? BGRiBlndProcessors.this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * BGRiBlndProcessors.this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < BGRiBlndProcessors.this.StnclSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.StnclSrcHeight && py >= 0 ? BGRiBlndProcessors.this.StnclSrcB[(sy + BGRiBlndProcessors.this.StnclSrcHeight) % BGRiBlndProcessors.this.StnclSrcHeight * BGRiBlndProcessors.this.StnclSrcWidth + (sx + BGRiBlndProcessors.this.StnclSrcWidth) % BGRiBlndProcessors.this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BGRiBlndProcessors.this.BlndCoeffLookup[Math.min(s, BGRiBlndProcessors.this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < BGRiBlndProcessors.this.ColSrcWidth && px >= 0 && py < BGRiBlndProcessors.this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + BGRiBlndProcessors.this.ColSrcHeight) % BGRiBlndProcessors.this.ColSrcHeight * BGRiBlndProcessors.this.ColSrcWidth * 3 + (px + BGRiBlndProcessors.this.ColSrcWidth) % BGRiBlndProcessors.this.ColSrcWidth * 3;
                        double SrcRdi = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double SrcGni = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double SrcBli = (double)(BGRiBlndProcessors.this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double V = (double)0.299f * SrcRdi + (double)0.587f * SrcGni + (double)0.114f * SrcBli;
                        if (V >= 0.04 && V < 0.98) {
                            double H = (double)0.596f * SrcRdi + (double)-0.274f * SrcGni + (double)-0.322f * SrcBli;
                            double S = (double)0.211f * SrcRdi + (double)-0.523f * SrcGni + (double)0.312f * SrcBli;
                            double FxdCnvsRdi = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                            double FxdCnvsGni = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                            double FxdCnvsBli = (double)(BGRiBlndProcessors.this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                            V = (double)0.299f * FxdCnvsRdi + (double)0.587f * FxdCnvsGni + (double)0.114f * FxdCnvsBli;
                            double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                            double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                            double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                            R = Math.max(R, 0.0);
                            G = Math.max(G, 0.0);
                            B = Math.max(B, 0.0);
                            if (R > 1.0 || G > 1.0 || B > 1.0) {
                                double temp = Math.max(Math.max(R, G), B);
                                R /= temp;
                                G /= temp;
                                B /= temp;
                            }
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                        } else {
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                            BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 2] = BGRiBlndProcessors.this.FxdCnvsB[ci + 2];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 1] = BGRiBlndProcessors.this.FxdCnvsB[ci + 1];
                        BGRiBlndProcessors.this.BlndCnvsB[ci + 0] = BGRiBlndProcessors.this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * BGRiBlndProcessors.this.CnvsWidth;
            }
        }
    }
}

