/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.BlndProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BlndProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiBlndStaticProcessors
implements BlndProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final BlndTrgts[] BlndPs = new BlndTrgts[]{new PureClrProcessor(), new SftLtProcessor(), new SftLtHrdLtProcessor(), new HrdLtProcessor(), new HrdLtIdntyProcessor(), new IdntyProcessor(), new IdntyMultProcessor(), new MultProcessor(), new MultScrnProcessor(), new ScrnProcessor(), new PureValProcessor()};
    private static final double[][] BlndCoeffLookup = new double[256][101];
    private static final double[] ClrCoeffLookup = new double[256];

    @Override
    public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
        for (BlndTrgts BlndP : this.BlndPs) {
            BlndP.setColSrcTrgt(SrcSize, Src);
        }
    }

    @Override
    public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
        for (BlndTrgts BlndP : this.BlndPs) {
            BlndP.setStnclSrcTrgt(SrcSize, Src);
        }
    }

    @Override
    public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
        for (BlndTrgts BlndP : this.BlndPs) {
            BlndP.setCnvsTrgt(CnvsSize, FxdCnvs, BlndCnvs, SelMsk);
        }
    }

    @Override
    public BlndProcessor getBlndProcessor(int BlndProcess) {
        return this.BlndPs[BlndProcess];
    }

    static {
        for (int i = 0; i < 256; ++i) {
            BGRiBlndStaticProcessors.ClrCoeffLookup[i] = (double)i / 255.0;
            for (int j = 0; j < 101; ++j) {
                BGRiBlndStaticProcessors.BlndCoeffLookup[i][j] = (double)i / 255.0 * ((double)j / 100.0);
            }
        }
    }

    static class PureValProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        PureValProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double FxdCnvsRdi = (double)(this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                        double FxdCnvsGni = (double)(this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                        double FxdCnvsBli = (double)(this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                        double H = (double)0.596f * FxdCnvsRdi + (double)-0.274f * FxdCnvsGni + (double)-0.322f * FxdCnvsBli;
                        double S = (double)0.211f * FxdCnvsRdi + (double)-0.523f * FxdCnvsGni + (double)0.312f * FxdCnvsBli;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                        double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                        double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                        R = Math.max(R, 0.0);
                        G = Math.max(G, 0.0);
                        B = Math.max(B, 0.0);
                        if (R > 1.0 || G > 1.0 || B > 1.0) {
                            double temp = Math.max(Math.max(R, G), B);
                            R /= temp;
                            G /= temp;
                            B /= temp;
                        }
                        this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                        this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                        this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double FxdCnvsRdi = (double)(this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                        double FxdCnvsGni = (double)(this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                        double FxdCnvsBli = (double)(this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                        double H = (double)0.596f * FxdCnvsRdi + (double)-0.274f * FxdCnvsGni + (double)-0.322f * FxdCnvsBli;
                        double S = (double)0.211f * FxdCnvsRdi + (double)-0.523f * FxdCnvsGni + (double)0.312f * FxdCnvsBli;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                        double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                        double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                        R = Math.max(R, 0.0);
                        G = Math.max(G, 0.0);
                        B = Math.max(B, 0.0);
                        if (R > 1.0 || G > 1.0 || B > 1.0) {
                            double temp = Math.max(Math.max(R, G), B);
                            R /= temp;
                            G /= temp;
                            B /= temp;
                        }
                        this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                        this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                        this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class ScrnProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        ScrnProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF];
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((BlndSrcRdd + ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((BlndSrcGnd + ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((BlndSrcBld + ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF];
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((BlndSrcRdd + ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((BlndSrcGnd + ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((BlndSrcBld + ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class MultScrnProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        MultScrnProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF];
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF];
                        double BlndSrcGnd = ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF];
                        double BlndSrcBld = ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF];
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0) + MnrCoef * ((BlndSrcRdd + ClrCoeffLookup[FxdCnvsRdi] * (1.0 - BlndSrcRdd)) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0) + MnrCoef * ((BlndSrcGnd + ClrCoeffLookup[FxdCnvsGni] * (1.0 - BlndSrcGnd)) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0) + MnrCoef * ((BlndSrcBld + ClrCoeffLookup[FxdCnvsBli] * (1.0 - BlndSrcBld)) * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class MultProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        MultProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class IdntyMultProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        IdntyMultProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * mp10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 2] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 1] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 0] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 2] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 2] & 0xFF] * ClrCoeffLookup[FxdCnvsRdi] * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 1] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 1] & 0xFF] * ClrCoeffLookup[FxdCnvsGni] * 255.0)) + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)(this.ColSrcB[pi + 0] & 0xFF) + MnrCoef * (ClrCoeffLookup[this.ColSrcB[pi + 0] & 0xFF] * ClrCoeffLookup[FxdCnvsBli] * 255.0)) + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class IdntyProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        IdntyProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)(this.ColSrcB[pi + 2] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 2] & 0xFF));
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)(this.ColSrcB[pi + 1] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 1] & 0xFF));
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)(this.ColSrcB[pi + 0] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 0] & 0xFF));
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)(this.ColSrcB[pi + 2] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 2] & 0xFF));
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)(this.ColSrcB[pi + 1] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 1] & 0xFF));
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)(this.ColSrcB[pi + 0] & 0xFF) + cf1 * (double)(this.FxdCnvsB[ci + 0] & 0xFF));
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class HrdLtIdntyProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        HrdLtIdntyProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcRdi) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MnrCoef * (double)BlndSrcRdi) + cf1 * (double)this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcGni) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MnrCoef * (double)BlndSrcGni) + cf1 * (double)this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + MnrCoef * (double)BlndSrcBli) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MnrCoef * (double)BlndSrcBli) + cf1 * (double)this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class HrdLtProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        HrdLtProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class SftLtHrdLtProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        SftLtHrdLtProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        double FxdCnvsRdd = ClrCoeffLookup[FxdCnvsRdi];
                        double FxdCnvsGnd = ClrCoeffLookup[FxdCnvsGni];
                        double FxdCnvsBld = ClrCoeffLookup[FxdCnvsBli];
                        int BlndSrcRdi = this.ColSrcB[pi + 2] & 0xFF;
                        int BlndSrcGni = this.ColSrcB[pi + 1] & 0xFF;
                        int BlndSrcBli = this.ColSrcB[pi + 0] & 0xFF;
                        double BlndSrcRdd = ClrCoeffLookup[BlndSrcRdi];
                        double BlndSrcGnd = ClrCoeffLookup[BlndSrcGni];
                        double BlndSrcBld = ClrCoeffLookup[BlndSrcBli];
                        if (BlndSrcRdd < 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * (FxdCnvsRdd * 2.0 * BlndSrcRdd * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd > 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]] + MnrCoef * ((2.0 * (BlndSrcRdd - 0.5) + FxdCnvsRdd * (1.0 - 2.0 * (BlndSrcRdd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsRdi);
                        } else if (BlndSrcRdd == 0.5) {
                            this.BlndCnvsB[ci + 2] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[BlndSrcRdi]]) + cf1 * (double)this.FxdCnvsB[ci + 2]);
                        }
                        if (BlndSrcGnd < 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * (FxdCnvsGnd * 2.0 * BlndSrcGnd * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd > 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]] + MnrCoef * ((2.0 * (BlndSrcGnd - 0.5) + FxdCnvsGnd * (1.0 - 2.0 * (BlndSrcGnd - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsGni);
                        } else if (BlndSrcGnd == 0.5) {
                            this.BlndCnvsB[ci + 1] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[BlndSrcGni]]) + cf1 * (double)this.FxdCnvsB[ci + 1]);
                        }
                        if (BlndSrcBld < 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * (FxdCnvsBld * 2.0 * BlndSrcBld * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld > 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]] + MnrCoef * ((2.0 * (BlndSrcBld - 0.5) + FxdCnvsBld * (1.0 - 2.0 * (BlndSrcBld - 0.5))) * 255.0)) + cf1 * (double)FxdCnvsBli);
                        } else if (BlndSrcBld == 0.5) {
                            this.BlndCnvsB[ci + 0] = (byte)(cf0 * (MjrCoef * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[BlndSrcBli]]) + cf1 * (double)this.FxdCnvsB[ci + 0]);
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class SftLtProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        SftLtProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[this.ColSrcB[pi + 2] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[this.ColSrcB[pi + 1] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[this.ColSrcB[pi + 0] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int[] SftLt0 = ImageProcessorTables.SftLt0;
            int[][] SftLt1 = ImageProcessorTables.SftLt1;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        int FxdCnvsRdi = this.FxdCnvsB[ci + 2] & 0xFF;
                        int FxdCnvsGni = this.FxdCnvsB[ci + 1] & 0xFF;
                        int FxdCnvsBli = this.FxdCnvsB[ci + 0] & 0xFF;
                        this.BlndCnvsB[ci + 2] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsRdi]][SftLt0[this.ColSrcB[pi + 2] & 0xFF]] + cf1 * (double)FxdCnvsRdi);
                        this.BlndCnvsB[ci + 1] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsGni]][SftLt0[this.ColSrcB[pi + 1] & 0xFF]] + cf1 * (double)FxdCnvsGni);
                        this.BlndCnvsB[ci + 0] = (byte)(cf0 * (double)SftLt1[SftLt0[FxdCnvsBli]][SftLt0[this.ColSrcB[pi + 0] & 0xFF]] + cf1 * (double)FxdCnvsBli);
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static class PureClrProcessor
    implements BlndTrgts {
        protected DataBufferByte SelMskDB = null;
        protected DataBufferByte ColSrcDB = null;
        protected DataBufferByte StnclSrcDB = null;
        protected DataBufferByte BlndCnvsDB = null;
        protected DataBufferByte FxdCnvsDB = null;
        protected byte[] ColSrcB = null;
        protected int ColSrcWidth = 0;
        protected int ColSrcHeight = 0;
        protected byte[] StnclSrcB = null;
        protected int StnclSrcWidth = 0;
        protected int StnclSrcHeight = 0;
        protected byte[] SelMskB = null;
        protected byte[] BlndCnvsB = null;
        protected byte[] FxdCnvsB = null;
        protected int CnvsWidth = 0;
        protected int CnvsHeight = 0;

        PureClrProcessor() {
        }

        @Override
        public void setColSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.ColSrcDB = (DataBufferByte)Src;
            this.ColSrcB = this.ColSrcDB.getData(0);
            this.ColSrcWidth = SrcSize.width;
            this.ColSrcHeight = SrcSize.height;
        }

        @Override
        public void setStnclSrcTrgt(Rectangle SrcSize, DataBuffer Src) {
            this.StnclSrcDB = (DataBufferByte)Src;
            this.StnclSrcB = this.StnclSrcDB.getData(0);
            this.StnclSrcWidth = SrcSize.width;
            this.StnclSrcHeight = SrcSize.height;
        }

        @Override
        public void setCnvsTrgt(Rectangle CnvsSize, DataBuffer FxdCnvs, DataBuffer BlndCnvs, DataBuffer SelMsk) {
            this.BlndCnvsDB = (DataBufferByte)BlndCnvs;
            this.FxdCnvsDB = (DataBufferByte)FxdCnvs;
            this.BlndCnvsB = this.BlndCnvsDB.getData(0);
            this.FxdCnvsB = this.FxdCnvsDB.getData(0);
            this.SelMskDB = (DataBufferByte)SelMsk;
            this.SelMskB = this.SelMskDB.getData(0);
            this.CnvsWidth = CnvsSize.width;
            this.CnvsHeight = CnvsSize.height;
        }

        @Override
        public final void processPixels(double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            int y = 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = 0;
            while (y < this.CnvsHeight) {
                int x = 0;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i;
                int ci = i * 3;
                while (x < this.CnvsWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        double CnvsRdi = (double)(this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double CnvsGni = (double)(this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double CnvsBli = (double)(this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double V = (double)0.299f * CnvsRdi + (double)0.587f * CnvsGni + (double)0.114f * CnvsBli;
                        if (V >= 0.04 && V < 0.98) {
                            double H = (double)0.596f * CnvsRdi + (double)-0.274f * CnvsGni + (double)-0.322f * CnvsBli;
                            double S = (double)0.211f * CnvsRdi + (double)-0.523f * CnvsGni + (double)0.312f * CnvsBli;
                            double FxdCnvsRdi = (double)(this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                            double FxdCnvsGni = (double)(this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                            double FxdCnvsBli = (double)(this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                            V = (double)0.299f * FxdCnvsRdi + (double)0.587f * FxdCnvsGni + (double)0.114f * FxdCnvsBli;
                            double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                            double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                            double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                            R = Math.max(R, 0.0);
                            G = Math.max(G, 0.0);
                            B = Math.max(B, 0.0);
                            if (R > 1.0 || G > 1.0 || B > 1.0) {
                                double temp = Math.max(Math.max(R, G), B);
                                R /= temp;
                                G /= temp;
                                B /= temp;
                            }
                            this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                            this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                            this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                        } else {
                            this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                            this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                            this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }

        @Override
        public final void processPixels(int SelX, int SelY, int SelWidth, int SelHeight, double MjrCoef, double MnrCoef, int DfltCoef, double[] ColSrcTrns, boolean ColSrcWrap, double[] StnclSrcTrns, boolean StnclSrcWrap) {
            double mp00 = ColSrcTrns[0];
            double mp10 = ColSrcTrns[1];
            double mp01 = ColSrcTrns[2];
            double mp11 = ColSrcTrns[3];
            double mp02 = ColSrcTrns[4];
            double mp12 = ColSrcTrns[5];
            double ms00 = StnclSrcTrns[0];
            double ms10 = StnclSrcTrns[1];
            double ms01 = StnclSrcTrns[2];
            double ms11 = StnclSrcTrns[3];
            double ms02 = StnclSrcTrns[4];
            double ms12 = StnclSrcTrns[5];
            int s = 0;
            double cf1 = 0.0;
            SelWidth = SelWidth + SelX > this.CnvsWidth ? this.CnvsWidth : SelWidth + SelX;
            SelHeight = SelHeight + SelY > this.CnvsHeight ? this.CnvsHeight : SelHeight + SelY;
            SelX = SelX >= 0 ? SelX : 0;
            int y = SelY = SelY >= 0 ? SelY : 0;
            double mp11y = (double)y * mp11;
            double mp01y = (double)y * mp01;
            double ms11y = (double)y * ms11;
            double ms01y = (double)y * ms01;
            int i = SelY * this.CnvsWidth;
            while (y < SelHeight) {
                int x = SelX;
                double mp00x = (double)x * mp00;
                double mp10x = (double)x * mp10;
                double ms00x = (double)x * ms00;
                double ms10x = (double)x * ms10;
                int mi = i + SelX;
                int ci = i * 3 + SelX * 3;
                while (x < SelWidth) {
                    int px = (int)(mp00x + mp01y + mp02 + 0.5);
                    int py = (int)(mp10x + mp11y + mp12 + 0.5);
                    int sx = (int)(ms00x + ms01y + ms02 + 0.5);
                    int sy = (int)(ms10x + ms11y + ms12 + 0.5);
                    s = StnclSrcWrap || px < this.StnclSrcWidth && px >= 0 && py < this.StnclSrcHeight && py >= 0 ? this.StnclSrcB[(sy + this.StnclSrcHeight) % this.StnclSrcHeight * this.StnclSrcWidth + (sx + this.StnclSrcWidth) % this.StnclSrcWidth] & 0xFF : 255;
                    double cf0 = BlndCoeffLookup[Math.min(s, this.SelMskB[mi] & 0xFF)][DfltCoef];
                    if (cf0 > 0.0 && (ColSrcWrap || px < this.ColSrcWidth && px >= 0 && py < this.ColSrcHeight && py >= 0)) {
                        cf1 = 1.0 - cf0;
                        int pi = (py + this.ColSrcHeight) % this.ColSrcHeight * this.ColSrcWidth * 3 + (px + this.ColSrcWidth) % this.ColSrcWidth * 3;
                        double SrcRdi = (double)(this.ColSrcB[pi + 2] & 0xFF) / 255.0;
                        double SrcGni = (double)(this.ColSrcB[pi + 1] & 0xFF) / 255.0;
                        double SrcBli = (double)(this.ColSrcB[pi + 0] & 0xFF) / 255.0;
                        double V = (double)0.299f * SrcRdi + (double)0.587f * SrcGni + (double)0.114f * SrcBli;
                        if (V >= 0.04 && V < 0.98) {
                            double H = (double)0.596f * SrcRdi + (double)-0.274f * SrcGni + (double)-0.322f * SrcBli;
                            double S = (double)0.211f * SrcRdi + (double)-0.523f * SrcGni + (double)0.312f * SrcBli;
                            double FxdCnvsRdi = (double)(this.FxdCnvsB[ci + 2] & 0xFF) / 255.0;
                            double FxdCnvsGni = (double)(this.FxdCnvsB[ci + 1] & 0xFF) / 255.0;
                            double FxdCnvsBli = (double)(this.FxdCnvsB[ci + 0] & 0xFF) / 255.0;
                            V = (double)0.299f * FxdCnvsRdi + (double)0.587f * FxdCnvsGni + (double)0.114f * FxdCnvsBli;
                            double R = 1.0 * V + (double)0.956f * H + (double)0.621f * S;
                            double G = 1.0 * V + (double)-0.272f * H + (double)-0.647f * S;
                            double B = 1.0 * V + (double)-1.106f * H + (double)1.703f * S;
                            R = Math.max(R, 0.0);
                            G = Math.max(G, 0.0);
                            B = Math.max(B, 0.0);
                            if (R > 1.0 || G > 1.0 || B > 1.0) {
                                double temp = Math.max(Math.max(R, G), B);
                                R /= temp;
                                G /= temp;
                                B /= temp;
                            }
                            this.BlndCnvsB[ci + 2] = (byte)((cf0 * R + cf1 * FxdCnvsRdi) * 255.0);
                            this.BlndCnvsB[ci + 1] = (byte)((cf0 * G + cf1 * FxdCnvsGni) * 255.0);
                            this.BlndCnvsB[ci + 0] = (byte)((cf0 * B + cf1 * FxdCnvsBli) * 255.0);
                        } else {
                            this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                            this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                            this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                        }
                    } else {
                        this.BlndCnvsB[ci + 2] = this.FxdCnvsB[ci + 2];
                        this.BlndCnvsB[ci + 1] = this.FxdCnvsB[ci + 1];
                        this.BlndCnvsB[ci + 0] = this.FxdCnvsB[ci + 0];
                    }
                    mp00x = (double)(++x) * mp00;
                    mp10x = (double)x * mp10;
                    ms00x = (double)x * ms00;
                    ms10x = (double)x * ms10;
                    mi = i + x;
                    ci = i * 3 + x * 3;
                }
                mp11y = (double)(++y) * mp11;
                mp01y = (double)y * mp01;
                ms11y = (double)y * ms11;
                ms01y = (double)y * ms01;
                i = y * this.CnvsWidth;
            }
        }
    }

    static interface BlndTrgts
    extends BlndProcessor {
        public void setColSrcTrgt(Rectangle var1, DataBuffer var2);

        public void setStnclSrcTrgt(Rectangle var1, DataBuffer var2);

        public void setCnvsTrgt(Rectangle var1, DataBuffer var2, DataBuffer var3, DataBuffer var4);
    }
}

