/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiBrtnsCtrstProcessors
implements BrtnsCtrstProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final BrtnsCtrstProcessor BrtnsCtrstCpy = new RGBiBrtnsCtrstCpyImpl();
    private final BrtnsCtrstProcessor BrtnsCtrst0_50 = new RGBiBrtnsCtrst0_50Impl();
    private final BrtnsCtrstProcessor BrtnsCtrst50_100 = new RGBiBrtnsCtrst50_100Impl();
    private final BrtnsCtrstProcessor BrtnsCtrstThhld = new RGBiBrtnsCtrstThhldImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcB = null;
    protected byte[] DstB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcB = this.SrcDB.getData(0);
        this.DstB = this.DstDB.getData(0);
    }

    @Override
    public BrtnsCtrstProcessor getBrtnsCtrstProcessor(int Val, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            return this.BrtnsCtrstCpy;
        }
        if (Val == 100) {
            return this.BrtnsCtrstThhld;
        }
        if (Ctrst < 50.0) {
            return this.BrtnsCtrst0_50;
        }
        return this.BrtnsCtrst50_100;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            this.BrtnsCtrstCpy.processImage(Brtns, Ctrst);
        } else if (Brtns > 1.85) {
            this.BrtnsCtrstThhld.processImage(Brtns, Ctrst);
        } else if (Ctrst < 50.0) {
            this.BrtnsCtrst0_50.processImage(Brtns, Ctrst);
        } else {
            this.BrtnsCtrst50_100.processImage(Brtns, Ctrst);
        }
    }

    class RGBiBrtnsCtrstThhldImpl
    implements BrtnsCtrstProcessor {
        RGBiBrtnsCtrstThhldImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int threshold = 255 - (int)(Ctrst * 2.55);
            for (int i = 0; i < BGRiBrtnsCtrstProcessors.this.SrcB.length; i += 3) {
                if ((BGRiBrtnsCtrstProcessors.this.SrcB[i + 2] & 0xFF) < threshold && (BGRiBrtnsCtrstProcessors.this.SrcB[i + 1] & 0xFF) < threshold && (BGRiBrtnsCtrstProcessors.this.SrcB[i + 0] & 0xFF) < threshold) {
                    BGRiBrtnsCtrstProcessors.this.DstB[i + 2] = 0;
                    BGRiBrtnsCtrstProcessors.this.DstB[i + 1] = 0;
                    BGRiBrtnsCtrstProcessors.this.DstB[i + 0] = 0;
                    continue;
                }
                BGRiBrtnsCtrstProcessors.this.DstB[i + 2] = -1;
                BGRiBrtnsCtrstProcessors.this.DstB[i + 1] = -1;
                BGRiBrtnsCtrstProcessors.this.DstB[i + 0] = -1;
            }
        }
    }

    class RGBiBrtnsCtrst50_100Impl
    implements BrtnsCtrstProcessor {
        RGBiBrtnsCtrst50_100Impl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma50_100[(int)Ctrst];
            for (int i = 0; i < BGRiBrtnsCtrstProcessors.this.SrcB.length; i += 3) {
                BGRiBrtnsCtrstProcessors.this.DstB[i + 2] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 2] & 0xFF]));
                BGRiBrtnsCtrstProcessors.this.DstB[i + 1] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 1] & 0xFF]));
                BGRiBrtnsCtrstProcessors.this.DstB[i + 0] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 0] & 0xFF]));
            }
        }
    }

    class RGBiBrtnsCtrst0_50Impl
    implements BrtnsCtrstProcessor {
        RGBiBrtnsCtrst0_50Impl() {
        }

        @Override
        public final void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma0_50[(int)Ctrst];
            for (int i = 0; i < BGRiBrtnsCtrstProcessors.this.SrcB.length; i += 3) {
                BGRiBrtnsCtrstProcessors.this.DstB[i + 2] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 2] & 0xFF]));
                BGRiBrtnsCtrstProcessors.this.DstB[i + 1] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 1] & 0xFF]));
                BGRiBrtnsCtrstProcessors.this.DstB[i + 0] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][BGRiBrtnsCtrstProcessors.this.SrcB[i + 0] & 0xFF]));
            }
        }
    }

    class RGBiBrtnsCtrstCpyImpl
    implements BrtnsCtrstProcessor {
        RGBiBrtnsCtrstCpyImpl() {
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            System.arraycopy(BGRiBrtnsCtrstProcessors.this.SrcB, 0, BGRiBrtnsCtrstProcessors.this.DstB, 0, BGRiBrtnsCtrstProcessors.this.SrcB.length);
        }
    }
}

