/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessor;
import com.Fo2PiX.blendengine.imageprocessors.BrtnsCtrstProcessors;
import com.Fo2PiX.blendengine.imageprocessors.ImageProcessorTables;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiBrtnsCtrstStaticProcessors
implements BrtnsCtrstProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final RGBiBrtnsCtrstCpyImpl BrtnsCtrstCpy = new RGBiBrtnsCtrstCpyImpl();
    private final RGBiBrtnsCtrst0_50Impl BrtnsCtrst0_50 = new RGBiBrtnsCtrst0_50Impl();
    private final RGBiBrtnsCtrst50_100Impl BrtnsCtrst50_100 = new RGBiBrtnsCtrst50_100Impl();
    private final RGBiBrtnsCtrstThhldImpl BrtnsCtrstThhld = new RGBiBrtnsCtrstThhldImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.BrtnsCtrstCpy.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrst0_50.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrst50_100.setTrgts(SrcB, DstB, Width, Height);
        this.BrtnsCtrstThhld.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public BrtnsCtrstProcessor getBrtnsCtrstProcessor(int Val, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            return this.BrtnsCtrstCpy;
        }
        if (Val == 100) {
            return this.BrtnsCtrstThhld;
        }
        if (Ctrst < 50.0) {
            return this.BrtnsCtrst0_50;
        }
        return this.BrtnsCtrst50_100;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, double Brtns, double Ctrst) {
        if (Brtns == 1.0 && Ctrst == 50.0) {
            this.BrtnsCtrstCpy.processImage(Brtns, Ctrst);
        } else if (Brtns > 1.85) {
            this.BrtnsCtrstThhld.processImage(Brtns, Ctrst);
        } else if (Ctrst < 50.0) {
            this.BrtnsCtrst0_50.processImage(Brtns, Ctrst);
        } else {
            this.BrtnsCtrst50_100.processImage(Brtns, Ctrst);
        }
    }

    static class RGBiBrtnsCtrstThhldImpl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiBrtnsCtrstThhldImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int threshold = 255 - (int)(Ctrst * 2.55);
            for (int i = 0; i < this.SrcB.length; i += 3) {
                if ((this.SrcB[i + 2] & 0xFF) < threshold && (this.SrcB[i + 1] & 0xFF) < threshold && (this.SrcB[i + 0] & 0xFF) < threshold) {
                    this.DstB[i + 2] = 0;
                    this.DstB[i + 1] = 0;
                    this.DstB[i + 0] = 0;
                    continue;
                }
                this.DstB[i + 2] = -1;
                this.DstB[i + 1] = -1;
                this.DstB[i + 0] = -1;
            }
        }
    }

    static class RGBiBrtnsCtrst50_100Impl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiBrtnsCtrst50_100Impl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma50_100[(int)Ctrst];
            for (int i = 0; i < this.SrcB.length; i += 3) {
                this.DstB[i + 2] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][this.SrcB[i + 2] & 0xFF]));
                this.DstB[i + 1] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][this.SrcB[i + 1] & 0xFF]));
                this.DstB[i + 0] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table50_100[Gamma][this.SrcB[i + 0] & 0xFF]));
            }
        }
    }

    static class RGBiBrtnsCtrst0_50Impl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiBrtnsCtrst0_50Impl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public final void processImage(double Brtns, double Ctrst) {
            int Gamma = ImageProcessorTables.Gamma0_50[(int)Ctrst];
            for (int i = 0; i < this.SrcB.length; i += 3) {
                this.DstB[i + 2] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][this.SrcB[i + 2] & 0xFF]));
                this.DstB[i + 1] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][this.SrcB[i + 1] & 0xFF]));
                this.DstB[i + 0] = (byte)(255.0 * Math.min(1.0, Brtns * ImageProcessorTables.Table0_50[Gamma][this.SrcB[i + 0] & 0xFF]));
            }
        }
    }

    static class RGBiBrtnsCtrstCpyImpl
    implements BrtnsCtrstProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiBrtnsCtrstCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(double Brtns, double Ctrst) {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

