/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.GryScleProcessor;
import com.Fo2PiX.blendengine.imageprocessors.GryScleProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiGryScleProcessors
implements GryScleProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final GryScleProcessor GryScleCpy = new RGBiGryScleCpyImpl();
    private final GryScleProcessor GryScleLin = new RGBiGryScleLinImpl();
    private final GryScleProcessor GryScleNTSC = new RGBiGryScleNTSCImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;
    protected byte[] SrcB = null;
    protected byte[] DstB = null;
    protected int Width = 0;
    protected int Height = 0;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        this.SrcB = this.SrcDB.getData(0);
        this.DstB = this.DstDB.getData(0);
        this.Width = Size.width;
        this.Height = Size.height;
    }

    @Override
    public GryScleProcessor getGryScleProcessor(int Type) {
        switch (Type) {
            case 0: {
                return this.GryScleCpy;
            }
            case 1: {
                return this.GryScleLin;
            }
            case 2: {
                return this.GryScleNTSC;
            }
        }
        return this.GryScleLin;
    }

    @Override
    public void process(int Type) {
        switch (Type) {
            case 0: {
                this.GryScleCpy.processImage();
                break;
            }
            case 1: {
                this.GryScleLin.processImage();
                break;
            }
            case 2: {
                this.GryScleNTSC.processImage();
                break;
            }
            default: {
                this.GryScleLin.processImage();
            }
        }
    }

    class RGBiGryScleNTSCImpl
    implements GryScleProcessor {
        double r;
        double g;
        double b;
        double v;
        byte Grey;

        RGBiGryScleNTSCImpl() {
        }

        @Override
        public void processImage() {
            for (int i = 0; i < BGRiGryScleProcessors.this.SrcB.length; i += 3) {
                this.r = (double)(BGRiGryScleProcessors.this.SrcB[i + 2] & 0xFF) * 0.299;
                this.g = (double)(BGRiGryScleProcessors.this.SrcB[i + 1] & 0xFF) * 0.587;
                this.b = (double)(BGRiGryScleProcessors.this.SrcB[i + 0] & 0xFF) * 0.114;
                this.v = this.r + this.g + this.b;
                BGRiGryScleProcessors.this.DstB[i + 2] = this.Grey = (byte)((this.v <= 255.0 ? this.v : (this.v = 255.0)) >= 0.0 ? this.v : 0.0);
                BGRiGryScleProcessors.this.DstB[i + 1] = this.Grey;
                BGRiGryScleProcessors.this.DstB[i + 0] = this.Grey;
            }
        }
    }

    class RGBiGryScleLinImpl
    implements GryScleProcessor {
        byte Grey;

        RGBiGryScleLinImpl() {
        }

        @Override
        public void processImage() {
            for (int i = 0; i < BGRiGryScleProcessors.this.SrcB.length; i += 3) {
                BGRiGryScleProcessors.this.DstB[i + 2] = this.Grey = (byte)(((BGRiGryScleProcessors.this.SrcB[i + 2] & 0xFF) + (BGRiGryScleProcessors.this.SrcB[i + 1] & 0xFF) + (BGRiGryScleProcessors.this.SrcB[i + 0] & 0xFF)) / 3);
                BGRiGryScleProcessors.this.DstB[i + 1] = this.Grey;
                BGRiGryScleProcessors.this.DstB[i + 0] = this.Grey;
            }
        }
    }

    class RGBiGryScleCpyImpl
    implements GryScleProcessor {
        RGBiGryScleCpyImpl() {
        }

        @Override
        public void processImage() {
            System.arraycopy(BGRiGryScleProcessors.this.SrcB, 0, BGRiGryScleProcessors.this.DstB, 0, BGRiGryScleProcessors.this.SrcB.length);
        }
    }
}

