/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.GryScleProcessor;
import com.Fo2PiX.blendengine.imageprocessors.GryScleProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiGryScleStaticProcessors
implements GryScleProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    private final RGBiGryScleCpyImpl GryScleCpy = new RGBiGryScleCpyImpl();
    private final RGBiGryScleLinImpl GryScleLin = new RGBiGryScleLinImpl();
    private final RGBiGryScleNTSCImpl GryScleNTSC = new RGBiGryScleNTSCImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.GryScleCpy.setTrgts(SrcB, DstB, Width, Height);
        this.GryScleLin.setTrgts(SrcB, DstB, Width, Height);
        this.GryScleNTSC.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public GryScleProcessor getGryScleProcessor(int Type) {
        switch (Type) {
            case 0: {
                return this.GryScleCpy;
            }
            case 1: {
                return this.GryScleLin;
            }
            case 2: {
                return this.GryScleNTSC;
            }
        }
        return this.GryScleLin;
    }

    @Override
    public void process(int Type) {
        switch (Type) {
            case 0: {
                this.GryScleCpy.processImage();
                break;
            }
            case 1: {
                this.GryScleLin.processImage();
                break;
            }
            case 2: {
                this.GryScleNTSC.processImage();
                break;
            }
            default: {
                this.GryScleLin.processImage();
            }
        }
    }

    static class RGBiGryScleNTSCImpl
    implements GryScleProcessor {
        double r;
        double g;
        double b;
        double v;
        byte Grey;
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiGryScleNTSCImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            for (int i = 0; i < this.SrcB.length; i += 3) {
                this.r = (double)(this.SrcB[i + 2] & 0xFF) * 0.299;
                this.g = (double)(this.SrcB[i + 1] & 0xFF) * 0.587;
                this.b = (double)(this.SrcB[i + 0] & 0xFF) * 0.114;
                this.v = this.r + this.g + this.b;
                this.DstB[i + 2] = this.Grey = (byte)((this.v <= 255.0 ? this.v : (this.v = 255.0)) >= 0.0 ? this.v : 0.0);
                this.DstB[i + 1] = this.Grey;
                this.DstB[i + 0] = this.Grey;
            }
        }
    }

    static class RGBiGryScleLinImpl
    implements GryScleProcessor {
        byte Grey;
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiGryScleLinImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            for (int i = 0; i < this.SrcB.length; i += 3) {
                this.DstB[i + 2] = this.Grey = (byte)(((this.SrcB[i + 2] & 0xFF) + (this.SrcB[i + 1] & 0xFF) + (this.SrcB[i + 0] & 0xFF)) / 3);
                this.DstB[i + 1] = this.Grey;
                this.DstB[i + 0] = this.Grey;
            }
        }
    }

    static class RGBiGryScleCpyImpl
    implements GryScleProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiGryScleCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage() {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

