/*
 * Decompiled with CFR 0.152.
 */
package com.Fo2PiX.blendengine.imageprocessors.bgri;

import com.Fo2PiX.blendengine.imageprocessors.HueSatProcessor;
import com.Fo2PiX.blendengine.imageprocessors.HueSatProcessors;
import java.awt.Rectangle;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;

public class BGRiHueSatStaticProcessors
implements HueSatProcessors {
    public static final int CHLS = 3;
    public static final int CHO_R = 2;
    public static final int CHO_G = 1;
    public static final int CHO_B = 0;
    public static final float[] HueSatModVal = new float[101];
    private final RGBiHueSatCpyImpl HueSatCpy = new RGBiHueSatCpyImpl();
    private final RGBiHueSatHSImpl HueSatHS = new RGBiHueSatHSImpl();
    private final RGBiHueSatHImpl HueSatH = new RGBiHueSatHImpl();
    private final RGBiHueSatSImpl HueSatS = new RGBiHueSatSImpl();
    protected DataBufferByte SrcDB = null;
    protected DataBufferByte DstDB = null;

    @Override
    public void setTrgts(Rectangle Size, DataBuffer Src, DataBuffer Dst) {
        this.SrcDB = (DataBufferByte)Src;
        this.DstDB = (DataBufferByte)Dst;
        byte[] SrcB = this.SrcDB.getData(0);
        byte[] DstB = this.DstDB.getData(0);
        int Width = Size.width;
        int Height = Size.height;
        this.HueSatCpy.setTrgts(SrcB, DstB, Width, Height);
        this.HueSatHS.setTrgts(SrcB, DstB, Width, Height);
        this.HueSatH.setTrgts(SrcB, DstB, Width, Height);
        this.HueSatS.setTrgts(SrcB, DstB, Width, Height);
    }

    @Override
    public HueSatProcessor getHueSatProcessor(int Hue, int Sat) {
        if (Hue == 50 && Sat == 50) {
            return this.HueSatCpy;
        }
        if (Hue == 50) {
            return this.HueSatS;
        }
        if (Sat == 50) {
            return this.HueSatH;
        }
        return this.HueSatHS;
    }

    @Override
    public void process(Rectangle Size, DataBuffer Src, DataBuffer Dst, int Hue, int Sat) {
        if (Hue == 50 && Sat == 50) {
            this.HueSatCpy.processImage(Hue, Sat);
        } else if (Hue == 50) {
            this.HueSatS.processImage(Hue, Sat);
        } else if (Sat == 50) {
            this.HueSatH.processImage(Hue, Sat);
        } else {
            this.HueSatHS.processImage(Hue, Sat);
        }
    }

    static {
        BGRiHueSatStaticProcessors.HueSatModVal[50] = 0.0f;
        for (int i = 0; i < 50; ++i) {
            BGRiHueSatStaticProcessors.HueSatModVal[i] = (float)(-0.02 * (double)(50 - i));
            BGRiHueSatStaticProcessors.HueSatModVal[100 - i] = (float)(0.02 * (double)(50 - i));
        }
    }

    static class RGBiHueSatSImpl
    implements HueSatProcessor {
        int red;
        int green;
        int blue;
        int huei;
        float redc;
        float greenc;
        float bluec;
        float hue;
        float saturation;
        float brightness;
        float huec;
        float p;
        float l;
        float t;
        float y;
        float i;
        float q;
        float hv;
        float sv;
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiHueSatSImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(int Hue, int Sat) {
            this.hv = HueSatModVal[Hue];
            this.sv = HueSatModVal[Sat];
            this.sv = (this.sv + 1.0f) * (this.sv + 1.0f) * (this.sv + 1.0f);
            this.hv /= 2.0f;
            for (int j = 0; j < this.SrcB.length; j += 3) {
                this.red = this.SrcB[j + 2] & 0xFF;
                this.green = this.SrcB[j + 1] & 0xFF;
                this.blue = this.SrcB[j + 0] & 0xFF;
                this.redc = (float)this.red / 255.0f;
                this.greenc = (float)this.green / 255.0f;
                this.bluec = (float)this.blue / 255.0f;
                this.y = 0.299f * this.redc + 0.587f * this.greenc + 0.114f * this.bluec;
                this.i = 0.596f * this.redc + -0.274f * this.greenc + -0.322f * this.bluec;
                this.q = 0.211f * this.redc + -0.523f * this.greenc + 0.312f * this.bluec;
                this.i *= this.sv;
                this.q *= this.sv;
                this.redc = 1.0f * this.y + 0.956f * this.i + 0.621f * this.q;
                this.greenc = 1.0f * this.y + -0.272f * this.i + -0.647f * this.q;
                this.bluec = 1.0f * this.y + -1.106f * this.i + 1.703f * this.q;
                this.redc = Math.max(this.redc, 0.0f);
                this.greenc = Math.max(this.greenc, 0.0f);
                this.bluec = Math.max(this.bluec, 0.0f);
                if (this.redc > 1.0f || this.greenc > 1.0f || this.bluec > 1.0f) {
                    float temp = Math.max(Math.max(this.redc, this.greenc), this.bluec);
                    this.redc /= temp;
                    this.greenc /= temp;
                    this.bluec /= temp;
                }
                this.red = (int)(this.redc * 255.0f + 0.5f);
                this.green = (int)(this.greenc * 255.0f + 0.5f);
                this.blue = (int)(this.bluec * 255.0f + 0.5f);
                this.DstB[j + 2] = (byte)this.red;
                this.DstB[j + 1] = (byte)this.green;
                this.DstB[j + 0] = (byte)this.blue;
            }
        }
    }

    static class RGBiHueSatHImpl
    implements HueSatProcessor {
        int red;
        int green;
        int blue;
        int huei;
        float redc;
        float greenc;
        float bluec;
        float hue;
        float saturation;
        float brightness;
        float huec;
        float p;
        float l;
        float t;
        float y;
        float i;
        float q;
        float hv;
        float sv;
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiHueSatHImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(int Hue, int Sat) {
            this.hv = HueSatModVal[Hue];
            this.hv /= 2.0f;
            for (int j = 0; j < this.SrcB.length; j += 3) {
                int cmin;
                int cmax;
                this.red = this.SrcB[j + 2] & 0xFF;
                this.green = this.SrcB[j + 1] & 0xFF;
                this.blue = this.SrcB[j + 0] & 0xFF;
                this.redc = (float)this.red / 255.0f;
                this.greenc = (float)this.green / 255.0f;
                this.bluec = (float)this.blue / 255.0f;
                int n = cmax = this.red > this.green ? this.red : this.green;
                if (this.blue > cmax) {
                    cmax = this.blue;
                }
                int n2 = cmin = this.red < this.green ? this.red : this.green;
                if (this.blue < cmin) {
                    cmin = this.blue;
                }
                this.brightness = (float)cmax / 255.0f;
                this.saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
                if (this.saturation == 0.0f) {
                    this.hue = 0.0f;
                } else {
                    this.redc = (float)(cmax - this.red) / (float)(cmax - cmin);
                    this.greenc = (float)(cmax - this.green) / (float)(cmax - cmin);
                    this.bluec = (float)(cmax - this.blue) / (float)(cmax - cmin);
                    this.hue = this.red == cmax ? this.bluec - this.greenc : (this.green == cmax ? 2.0f + this.redc - this.bluec : 4.0f + this.greenc - this.redc);
                    this.hue /= 6.0f;
                    if (this.hue < 0.0f) {
                        this.hue += 1.0f;
                    }
                }
                this.hue += this.hv;
                if (this.hue < 0.0f) {
                    this.hue += 1.0f;
                } else if (this.hue > 1.0f) {
                    this.hue -= 1.0f;
                }
                if (this.saturation == 0.0f) {
                    this.greenc = this.bluec = this.brightness;
                    this.redc = this.bluec;
                } else {
                    this.huec = (this.hue - (float)Math.floor(this.hue)) * 6.0f;
                    this.huei = (int)this.huec;
                    this.huec -= (float)Math.floor(this.huec);
                    this.p = this.brightness * (1.0f - this.saturation);
                    this.l = this.brightness * (1.0f - this.saturation * this.huec);
                    this.t = this.brightness * (1.0f - this.saturation * (1.0f - this.huec));
                    switch (this.huei) {
                        case 0: {
                            this.redc = this.brightness;
                            this.greenc = this.t;
                            this.bluec = this.p;
                            break;
                        }
                        case 1: {
                            this.redc = this.l;
                            this.greenc = this.brightness;
                            this.bluec = this.p;
                            break;
                        }
                        case 2: {
                            this.redc = this.p;
                            this.greenc = this.brightness;
                            this.bluec = this.t;
                            break;
                        }
                        case 3: {
                            this.redc = this.p;
                            this.greenc = this.l;
                            this.bluec = this.brightness;
                            break;
                        }
                        case 4: {
                            this.redc = this.t;
                            this.greenc = this.p;
                            this.bluec = this.brightness;
                            break;
                        }
                        case 5: {
                            this.redc = this.brightness;
                            this.greenc = this.p;
                            this.bluec = this.l;
                        }
                    }
                }
                this.red = (int)(this.redc * 255.0f + 0.5f);
                this.green = (int)(this.greenc * 255.0f + 0.5f);
                this.blue = (int)(this.bluec * 255.0f + 0.5f);
                this.DstB[j + 2] = (byte)this.red;
                this.DstB[j + 1] = (byte)this.green;
                this.DstB[j + 0] = (byte)this.blue;
            }
        }
    }

    static class RGBiHueSatHSImpl
    implements HueSatProcessor {
        int red;
        int green;
        int blue;
        int huei;
        float redc;
        float greenc;
        float bluec;
        float hue;
        float saturation;
        float brightness;
        float huec;
        float p;
        float l;
        float t;
        float y;
        float i;
        float q;
        float hv;
        float sv;
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiHueSatHSImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(int Hue, int Sat) {
            this.hv = HueSatModVal[Hue];
            this.sv = HueSatModVal[Sat];
            this.sv = (this.sv + 1.0f) * (this.sv + 1.0f) * (this.sv + 1.0f);
            this.hv /= 2.0f;
            for (int j = 0; j < this.SrcB.length; j += 3) {
                int cmin;
                int cmax;
                this.red = this.SrcB[j + 2] & 0xFF;
                this.green = this.SrcB[j + 1] & 0xFF;
                this.blue = this.SrcB[j + 0] & 0xFF;
                this.redc = (float)this.red / 255.0f;
                this.greenc = (float)this.green / 255.0f;
                this.bluec = (float)this.blue / 255.0f;
                int n = cmax = this.red > this.green ? this.red : this.green;
                if (this.blue > cmax) {
                    cmax = this.blue;
                }
                int n2 = cmin = this.red < this.green ? this.red : this.green;
                if (this.blue < cmin) {
                    cmin = this.blue;
                }
                this.brightness = (float)cmax / 255.0f;
                this.saturation = cmax != 0 ? (float)(cmax - cmin) / (float)cmax : 0.0f;
                if (this.saturation == 0.0f) {
                    this.hue = 0.0f;
                } else {
                    this.redc = (float)(cmax - this.red) / (float)(cmax - cmin);
                    this.greenc = (float)(cmax - this.green) / (float)(cmax - cmin);
                    this.bluec = (float)(cmax - this.blue) / (float)(cmax - cmin);
                    this.hue = this.red == cmax ? this.bluec - this.greenc : (this.green == cmax ? 2.0f + this.redc - this.bluec : 4.0f + this.greenc - this.redc);
                    this.hue /= 6.0f;
                    if (this.hue < 0.0f) {
                        this.hue += 1.0f;
                    }
                }
                this.hue += this.hv;
                if (this.hue < 0.0f) {
                    this.hue += 1.0f;
                } else if (this.hue > 1.0f) {
                    this.hue -= 1.0f;
                }
                if (this.saturation == 0.0f) {
                    this.greenc = this.bluec = this.brightness;
                    this.redc = this.bluec;
                } else {
                    this.huec = (this.hue - (float)Math.floor(this.hue)) * 6.0f;
                    this.huei = (int)this.huec;
                    this.huec -= (float)Math.floor(this.huec);
                    this.p = this.brightness * (1.0f - this.saturation);
                    this.l = this.brightness * (1.0f - this.saturation * this.huec);
                    this.t = this.brightness * (1.0f - this.saturation * (1.0f - this.huec));
                    switch (this.huei) {
                        case 0: {
                            this.redc = this.brightness;
                            this.greenc = this.t;
                            this.bluec = this.p;
                            break;
                        }
                        case 1: {
                            this.redc = this.l;
                            this.greenc = this.brightness;
                            this.bluec = this.p;
                            break;
                        }
                        case 2: {
                            this.redc = this.p;
                            this.greenc = this.brightness;
                            this.bluec = this.t;
                            break;
                        }
                        case 3: {
                            this.redc = this.p;
                            this.greenc = this.l;
                            this.bluec = this.brightness;
                            break;
                        }
                        case 4: {
                            this.redc = this.t;
                            this.greenc = this.p;
                            this.bluec = this.brightness;
                            break;
                        }
                        case 5: {
                            this.redc = this.brightness;
                            this.greenc = this.p;
                            this.bluec = this.l;
                        }
                    }
                }
                this.y = 0.299f * this.redc + 0.587f * this.greenc + 0.114f * this.bluec;
                this.i = 0.596f * this.redc + -0.274f * this.greenc + -0.322f * this.bluec;
                this.q = 0.211f * this.redc + -0.523f * this.greenc + 0.312f * this.bluec;
                this.i *= this.sv;
                this.q *= this.sv;
                this.redc = 1.0f * this.y + 0.956f * this.i + 0.621f * this.q;
                this.greenc = 1.0f * this.y + -0.272f * this.i + -0.647f * this.q;
                this.bluec = 1.0f * this.y + -1.106f * this.i + 1.703f * this.q;
                this.redc = Math.max(this.redc, 0.0f);
                this.greenc = Math.max(this.greenc, 0.0f);
                this.bluec = Math.max(this.bluec, 0.0f);
                if (this.redc > 1.0f || this.greenc > 1.0f || this.bluec > 1.0f) {
                    float temp = Math.max(Math.max(this.redc, this.greenc), this.bluec);
                    this.redc /= temp;
                    this.greenc /= temp;
                    this.bluec /= temp;
                }
                this.red = (int)(this.redc * 255.0f + 0.5f);
                this.green = (int)(this.greenc * 255.0f + 0.5f);
                this.blue = (int)(this.bluec * 255.0f + 0.5f);
                this.DstB[j + 2] = (byte)this.red;
                this.DstB[j + 1] = (byte)this.green;
                this.DstB[j + 0] = (byte)this.blue;
            }
        }
    }

    static class RGBiHueSatCpyImpl
    implements HueSatProcessor {
        protected byte[] SrcB = null;
        protected byte[] DstB = null;
        protected int Width = 0;
        protected int Height = 0;

        RGBiHueSatCpyImpl() {
        }

        protected void setTrgts(byte[] newSrcB, byte[] newDstB, int newWidth, int newHeight) {
            this.SrcB = newSrcB;
            this.DstB = newDstB;
            this.Width = newWidth;
            this.Height = newHeight;
        }

        @Override
        public void processImage(int Hue, int Sat) {
            System.arraycopy(this.SrcB, 0, this.DstB, 0, this.SrcB.length);
        }
    }
}

